/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.column;

import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.segment.column.AbstractColumn;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.io.druid.segment.column.GenericColumn;
import org.apache.hive.druid.io.druid.segment.column.IndexedLongsGenericColumn;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.CompressedLongsIndexedSupplier;

public class LongColumn
extends AbstractColumn {
    public static final int ROW_SIZE = 1;
    private static final ColumnCapabilitiesImpl CAPABILITIES = new ColumnCapabilitiesImpl().setType(ValueType.LONG);
    private static final ColumnCapabilitiesImpl CAPABILITIES_WITH_NULL = new ColumnCapabilitiesImpl().setType(ValueType.LONG);
    private final CompressedLongsIndexedSupplier column;
    private final ImmutableBitmap nullValueBitmap;

    public LongColumn(CompressedLongsIndexedSupplier column, ImmutableBitmap nullValueBitmap) {
        this.column = column;
        this.nullValueBitmap = nullValueBitmap;
    }

    @Override
    public ColumnCapabilities getCapabilities() {
        return this.nullValueBitmap.isEmpty() ? CAPABILITIES : CAPABILITIES_WITH_NULL;
    }

    @Override
    public int getLength() {
        return this.column.size();
    }

    @Override
    public GenericColumn getGenericColumn() {
        return new IndexedLongsGenericColumn(this.column.get(), this.nullValueBitmap);
    }
}

