/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.column;

import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.column.GenericColumn;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.IndexedLongs;
import org.apache.hive.druid.io.druid.segment.data.ReadableOffset;

public class IndexedLongsGenericColumn
implements GenericColumn {
    private final IndexedLongs column;
    private final ImmutableBitmap nullValueBitmap;

    public IndexedLongsGenericColumn(IndexedLongs column, ImmutableBitmap nullValueBitmap) {
        this.column = column;
        this.nullValueBitmap = nullValueBitmap;
    }

    @Override
    public int length() {
        return this.column.size();
    }

    @Override
    public ValueType getType() {
        return ValueType.LONG;
    }

    @Override
    public boolean hasMultipleValues() {
        return false;
    }

    @Override
    public String getStringSingleValueRow(int rowNum) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloatSingleValueRow(int rowNum) {
        return this.column.get(rowNum);
    }

    @Override
    public FloatColumnSelector makeFloatSingleValueRowSelector(ReadableOffset offset) {
        return this.column.makeFloatColumnSelector(offset, this.nullValueBitmap);
    }

    @Override
    public long getLongSingleValueRow(int rowNum) {
        return this.column.get(rowNum);
    }

    @Override
    public LongColumnSelector makeLongSingleValueRowSelector(ReadableOffset offset) {
        return this.column.makeLongColumnSelector(offset, this.nullValueBitmap);
    }

    @Override
    public double getDoubleSingleValueRow(int rowNum) {
        return this.column.get(rowNum);
    }

    @Override
    public DoubleColumnSelector makeDoubleSingleValueRowSelector(ReadableOffset offset) {
        return this.column.makeDoubleColumnSelector(offset, this.nullValueBitmap);
    }

    @Override
    public boolean isNull(int rowNum) {
        return this.nullValueBitmap.get(rowNum);
    }

    @Override
    public void close() {
        this.column.close();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("column", this.column);
    }
}

