/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.column;

import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.segment.column.AbstractColumn;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.io.druid.segment.column.GenericColumn;
import org.apache.hive.druid.io.druid.segment.column.IndexedDoublesGenericColumn;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.CompressedDoublesIndexedSupplier;

public class DoubleColumn
extends AbstractColumn {
    public static final int ROW_SIZE = 1;
    private static final ColumnCapabilitiesImpl CAPABILITIES = new ColumnCapabilitiesImpl().setType(ValueType.DOUBLE);
    private final CompressedDoublesIndexedSupplier column;
    private final ImmutableBitmap nullValueBitmap;

    public DoubleColumn(CompressedDoublesIndexedSupplier column, ImmutableBitmap nullValueBitmap) {
        this.column = column;
        this.nullValueBitmap = nullValueBitmap;
    }

    @Override
    public int getLength() {
        return this.column.size();
    }

    @Override
    public ColumnCapabilities getCapabilities() {
        return CAPABILITIES;
    }

    @Override
    public GenericColumn getGenericColumn() {
        return new IndexedDoublesGenericColumn(this.column.get(), this.nullValueBitmap);
    }
}

