/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.column;

import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ValueType;

public class ColumnCapabilitiesImpl
implements ColumnCapabilities {
    private ValueType type = null;
    private boolean dictionaryEncoded = false;
    private boolean runLengthEncoded = false;
    private boolean hasInvertedIndexes = false;
    private boolean hasSpatialIndexes = false;
    private boolean hasMultipleValues = false;

    @Override
    @JsonProperty
    public ValueType getType() {
        return this.type;
    }

    public ColumnCapabilitiesImpl setType(ValueType type) {
        this.type = type;
        return this;
    }

    @Override
    @JsonProperty
    public boolean isDictionaryEncoded() {
        return this.dictionaryEncoded;
    }

    public ColumnCapabilitiesImpl setDictionaryEncoded(boolean dictionaryEncoded) {
        this.dictionaryEncoded = dictionaryEncoded;
        return this;
    }

    @Override
    @JsonProperty
    public boolean isRunLengthEncoded() {
        return this.runLengthEncoded;
    }

    public ColumnCapabilitiesImpl setRunLengthEncoded(boolean runLengthEncoded) {
        this.runLengthEncoded = runLengthEncoded;
        return this;
    }

    @Override
    @JsonProperty(value="hasBitmapIndexes")
    public boolean hasBitmapIndexes() {
        return this.hasInvertedIndexes;
    }

    public ColumnCapabilitiesImpl setHasBitmapIndexes(boolean hasInvertedIndexes) {
        this.hasInvertedIndexes = hasInvertedIndexes;
        return this;
    }

    @Override
    @JsonProperty(value="hasSpatialIndexes")
    public boolean hasSpatialIndexes() {
        return this.hasSpatialIndexes;
    }

    public ColumnCapabilitiesImpl setHasSpatialIndexes(boolean hasSpatialIndexes) {
        this.hasSpatialIndexes = hasSpatialIndexes;
        return this;
    }

    @Override
    @JsonProperty(value="hasMultipleValues")
    public boolean hasMultipleValues() {
        return this.hasMultipleValues;
    }

    public ColumnCapabilitiesImpl setHasMultipleValues(boolean hasMultipleValues) {
        this.hasMultipleValues = hasMultipleValues;
        return this;
    }

    @Override
    public ColumnCapabilitiesImpl merge(ColumnCapabilities other) {
        if (other == null) {
            return this;
        }
        if (this.type == null) {
            this.type = other.getType();
        }
        if (!this.type.equals((Object)other.getType())) {
            throw new ISE("Cannot merge columns of type[%s] and [%s]", new Object[]{this.type, other.getType()});
        }
        this.dictionaryEncoded |= other.isDictionaryEncoded();
        this.runLengthEncoded |= other.isRunLengthEncoded();
        this.hasInvertedIndexes |= other.hasBitmapIndexes();
        this.hasSpatialIndexes |= other.hasSpatialIndexes();
        this.hasMultipleValues |= other.hasMultipleValues();
        return this;
    }
}

