/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.Arrays;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.io.druid.segment.DimensionHandler;
import org.joda.time.DateTime;

public class Rowboat
implements Comparable<Rowboat> {
    private final long timestamp;
    private final Object[] dims;
    private final Object[] metrics;
    private final int rowNum;
    private final Int2ObjectOpenHashMap<IntSortedSet> comprisedRows;
    private final DimensionHandler[] handlers;

    public Rowboat(long timestamp, Object[] dims, Object[] metrics, int rowNum, DimensionHandler[] handlers) {
        this.timestamp = timestamp;
        this.dims = dims;
        this.metrics = metrics;
        this.rowNum = rowNum;
        this.handlers = handlers;
        this.comprisedRows = new Int2ObjectOpenHashMap();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Object[] getDims() {
        return this.dims;
    }

    public Object[] getMetrics() {
        return this.metrics;
    }

    public void addRow(int indexNum, int rowNum) {
        IntSortedSet rowNums = this.comprisedRows.get(indexNum);
        if (rowNums == null) {
            rowNums = new IntRBTreeSet();
            this.comprisedRows.put(indexNum, rowNums);
        }
        rowNums.add(rowNum);
    }

    public Int2ObjectOpenHashMap<IntSortedSet> getComprisedRows() {
        return this.comprisedRows;
    }

    public DimensionHandler[] getHandlers() {
        return this.handlers;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    @Override
    public int compareTo(Rowboat rhs) {
        int retVal = Longs.compare(this.timestamp, rhs.timestamp);
        if (retVal == 0) {
            retVal = Ints.compare(this.dims.length, rhs.dims.length);
        }
        int index = 0;
        while (retVal == 0 && index < this.dims.length) {
            Object lhsVals = this.dims[index];
            Object rhsVals = rhs.dims[index];
            if (lhsVals == null) {
                if (rhsVals == null) {
                    ++index;
                    continue;
                }
                return -1;
            }
            if (rhsVals == null) {
                return 1;
            }
            DimensionHandler handler = this.handlers[index];
            retVal = handler.compareSortedEncodedKeyComponents(lhsVals, rhsVals);
            ++index;
        }
        return retVal;
    }

    public String toString() {
        return "Rowboat{timestamp=" + new DateTime(this.timestamp).toString() + ", dims=" + Arrays.deepToString(this.dims) + ", metrics=" + Arrays.toString(this.metrics) + ", comprisedRows=" + this.comprisedRows + '}';
    }
}

