/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.Closeable;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.java.util.common.io.Closer;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DimensionSelectorUtils;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.DoubleWrappingDimensionSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.FloatWrappingDimensionSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongWrappingDimensionSelector;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.QueryableIndexStorageAdapter;
import org.apache.hive.druid.io.druid.segment.SingleScanTimeDimSelector;
import org.apache.hive.druid.io.druid.segment.VirtualColumns;
import org.apache.hive.druid.io.druid.segment.ZeroDoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.ZeroFloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.ZeroLongColumnSelector;
import org.apache.hive.druid.io.druid.segment.column.Column;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ComplexColumn;
import org.apache.hive.druid.io.druid.segment.column.DictionaryEncodedColumn;
import org.apache.hive.druid.io.druid.segment.column.GenericColumn;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.ReadableOffset;

class QueryableIndexColumnSelectorFactory
implements ColumnSelectorFactory {
    private final QueryableIndex index;
    private final VirtualColumns virtualColumns;
    private final boolean descending;
    private final Closer closer;
    protected final ReadableOffset offset;
    private final Map<String, DictionaryEncodedColumn> dictionaryColumnCache;
    private final Map<String, GenericColumn> genericColumnCache;
    private final Map<String, Object> objectColumnCache;

    QueryableIndexColumnSelectorFactory(QueryableIndex index, VirtualColumns virtualColumns, boolean descending, Closer closer, ReadableOffset offset, Map<String, DictionaryEncodedColumn> dictionaryColumnCache, Map<String, GenericColumn> genericColumnCache, Map<String, Object> objectColumnCache) {
        this.index = index;
        this.virtualColumns = virtualColumns;
        this.descending = descending;
        this.closer = closer;
        this.offset = offset;
        this.dictionaryColumnCache = dictionaryColumnCache;
        this.genericColumnCache = genericColumnCache;
        this.objectColumnCache = objectColumnCache;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        if (this.virtualColumns.exists(dimensionSpec.getDimension())) {
            return this.virtualColumns.makeDimensionSelector(dimensionSpec, this);
        }
        return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        DictionaryEncodedColumn column;
        String dimension = dimensionSpec.getDimension();
        ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
        Column columnDesc = this.index.getColumn(dimension);
        if (columnDesc == null) {
            return DimensionSelectorUtils.constantSelector(null, extractionFn);
        }
        if (dimension.equals("__time")) {
            return new SingleScanTimeDimSelector(this.makeLongColumnSelector(dimension), extractionFn, this.descending);
        }
        if (columnDesc.getCapabilities().getType() == ValueType.LONG) {
            return new LongWrappingDimensionSelector(this.makeLongColumnSelector(dimension), extractionFn);
        }
        if (columnDesc.getCapabilities().getType() == ValueType.FLOAT) {
            return new FloatWrappingDimensionSelector(this.makeFloatColumnSelector(dimension), extractionFn);
        }
        if (columnDesc.getCapabilities().getType() == ValueType.DOUBLE) {
            return new DoubleWrappingDimensionSelector(this.makeDoubleColumnSelector(dimension), extractionFn);
        }
        DictionaryEncodedColumn cachedColumn = this.dictionaryColumnCache.get(dimension);
        if (cachedColumn == null) {
            cachedColumn = columnDesc.getDictionaryEncoding();
            this.closer.register(cachedColumn);
            this.dictionaryColumnCache.put(dimension, cachedColumn);
        }
        if ((column = cachedColumn) == null) {
            return DimensionSelectorUtils.constantSelector(null, extractionFn);
        }
        return column.makeDimensionSelector(this.offset, extractionFn);
    }

    @Override
    public FloatColumnSelector makeFloatColumnSelector(String columnName) {
        Column holder;
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeFloatColumnSelector(columnName, this);
        }
        GenericColumn cachedMetricVals = this.genericColumnCache.get(columnName);
        if (cachedMetricVals == null && (holder = this.index.getColumn(columnName)) != null && ValueType.isNumeric(holder.getCapabilities().getType())) {
            cachedMetricVals = holder.getGenericColumn();
            this.closer.register(cachedMetricVals);
            this.genericColumnCache.put(columnName, cachedMetricVals);
        }
        if (cachedMetricVals == null) {
            return ZeroFloatColumnSelector.instance();
        }
        return cachedMetricVals.makeFloatSingleValueRowSelector(this.offset);
    }

    @Override
    public DoubleColumnSelector makeDoubleColumnSelector(String columnName) {
        Column holder;
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeDoubleColumnSelector(columnName, this);
        }
        GenericColumn cachedMetricVals = this.genericColumnCache.get(columnName);
        if (cachedMetricVals == null && (holder = this.index.getColumn(columnName)) != null && ValueType.isNumeric(holder.getCapabilities().getType())) {
            cachedMetricVals = holder.getGenericColumn();
            this.closer.register(cachedMetricVals);
            this.genericColumnCache.put(columnName, cachedMetricVals);
        }
        if (cachedMetricVals == null) {
            return ZeroDoubleColumnSelector.instance();
        }
        return cachedMetricVals.makeDoubleSingleValueRowSelector(this.offset);
    }

    @Override
    public LongColumnSelector makeLongColumnSelector(String columnName) {
        Column holder;
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeLongColumnSelector(columnName, this);
        }
        GenericColumn cachedMetricVals = this.genericColumnCache.get(columnName);
        if (cachedMetricVals == null && (holder = this.index.getColumn(columnName)) != null && ValueType.isNumeric(holder.getCapabilities().getType())) {
            cachedMetricVals = holder.getGenericColumn();
            this.closer.register(cachedMetricVals);
            this.genericColumnCache.put(columnName, cachedMetricVals);
        }
        if (cachedMetricVals == null) {
            return ZeroLongColumnSelector.instance();
        }
        return cachedMetricVals.makeLongSingleValueRowSelector(this.offset);
    }

    @Override
    @Nullable
    public ObjectColumnSelector makeObjectColumnSelector(String column) {
        Closeable columnVals;
        if (this.virtualColumns.exists(column)) {
            return this.virtualColumns.makeObjectColumnSelector(column, this);
        }
        Object cachedColumnVals = this.objectColumnCache.get(column);
        if (cachedColumnVals == null) {
            Column holder = this.index.getColumn(column);
            if (holder != null) {
                ColumnCapabilities capabilities = holder.getCapabilities();
                cachedColumnVals = capabilities.isDictionaryEncoded() ? holder.getDictionaryEncoding() : (capabilities.getType() == ValueType.COMPLEX ? holder.getComplexColumn() : holder.getGenericColumn());
            }
            if (cachedColumnVals != null) {
                this.closer.register((Closeable)cachedColumnVals);
                this.objectColumnCache.put(column, cachedColumnVals);
            }
        }
        if (cachedColumnVals == null) {
            return null;
        }
        if (cachedColumnVals instanceof GenericColumn) {
            columnVals = (GenericColumn)cachedColumnVals;
            ValueType type = columnVals.getType();
            if (columnVals.hasMultipleValues()) {
                throw new UnsupportedOperationException("makeObjectColumnSelector does not support multi-value GenericColumns");
            }
            if (type == ValueType.FLOAT) {
                return new ObjectColumnSelector<Float>((GenericColumn)columnVals){
                    final /* synthetic */ GenericColumn val$columnVals;
                    {
                        this.val$columnVals = genericColumn;
                    }

                    @Override
                    public Class<Float> classOfObject() {
                        return Float.class;
                    }

                    @Override
                    public Float get() {
                        if (this.val$columnVals.isNull(QueryableIndexColumnSelectorFactory.this.offset.getOffset())) {
                            return null;
                        }
                        return Float.valueOf(this.val$columnVals.getFloatSingleValueRow(QueryableIndexColumnSelectorFactory.this.offset.getOffset()));
                    }
                };
            }
            if (type == ValueType.DOUBLE) {
                return new ObjectColumnSelector<Double>((GenericColumn)columnVals){
                    final /* synthetic */ GenericColumn val$columnVals;
                    {
                        this.val$columnVals = genericColumn;
                    }

                    @Override
                    public Class<Double> classOfObject() {
                        return Double.class;
                    }

                    @Override
                    public Double get() {
                        if (this.val$columnVals.isNull(QueryableIndexColumnSelectorFactory.this.offset.getOffset())) {
                            return null;
                        }
                        return this.val$columnVals.getDoubleSingleValueRow(QueryableIndexColumnSelectorFactory.this.offset.getOffset());
                    }
                };
            }
            if (type == ValueType.LONG) {
                return new ObjectColumnSelector<Long>((GenericColumn)columnVals){
                    final /* synthetic */ GenericColumn val$columnVals;
                    {
                        this.val$columnVals = genericColumn;
                    }

                    @Override
                    public Class<Long> classOfObject() {
                        return Long.class;
                    }

                    @Override
                    public Long get() {
                        if (this.val$columnVals.isNull(QueryableIndexColumnSelectorFactory.this.offset.getOffset())) {
                            return null;
                        }
                        return this.val$columnVals.getLongSingleValueRow(QueryableIndexColumnSelectorFactory.this.offset.getOffset());
                    }
                };
            }
            if (type == ValueType.STRING) {
                return new ObjectColumnSelector<String>((GenericColumn)columnVals){
                    final /* synthetic */ GenericColumn val$columnVals;
                    {
                        this.val$columnVals = genericColumn;
                    }

                    @Override
                    public Class<String> classOfObject() {
                        return String.class;
                    }

                    @Override
                    public String get() {
                        return this.val$columnVals.getStringSingleValueRow(QueryableIndexColumnSelectorFactory.this.offset.getOffset());
                    }
                };
            }
        }
        if (cachedColumnVals instanceof DictionaryEncodedColumn) {
            columnVals = (DictionaryEncodedColumn)cachedColumnVals;
            if (columnVals.hasMultipleValues()) {
                return new ObjectColumnSelector<Object>((DictionaryEncodedColumn)columnVals){
                    final /* synthetic */ DictionaryEncodedColumn val$columnVals;
                    {
                        this.val$columnVals = dictionaryEncodedColumn;
                    }

                    @Override
                    public Class<Object> classOfObject() {
                        return Object.class;
                    }

                    @Override
                    @Nullable
                    public Object get() {
                        IndexedInts multiValueRow = this.val$columnVals.getMultiValueRow(QueryableIndexColumnSelectorFactory.this.offset.getOffset());
                        if (multiValueRow.size() == 0) {
                            return null;
                        }
                        if (multiValueRow.size() == 1) {
                            return this.val$columnVals.lookupName(multiValueRow.get(0));
                        }
                        String[] strings = new String[multiValueRow.size()];
                        for (int i = 0; i < multiValueRow.size(); ++i) {
                            strings[i] = (String)this.val$columnVals.lookupName(multiValueRow.get(i));
                        }
                        return strings;
                    }
                };
            }
            return new ObjectColumnSelector<String>((DictionaryEncodedColumn)columnVals){
                final /* synthetic */ DictionaryEncodedColumn val$columnVals;
                {
                    this.val$columnVals = dictionaryEncodedColumn;
                }

                @Override
                public Class<String> classOfObject() {
                    return String.class;
                }

                @Override
                public String get() {
                    return (String)this.val$columnVals.lookupName(this.val$columnVals.getSingleValueRow(QueryableIndexColumnSelectorFactory.this.offset.getOffset()));
                }
            };
        }
        columnVals = (ComplexColumn)cachedColumnVals;
        return new ObjectColumnSelector((ComplexColumn)columnVals){
            final /* synthetic */ ComplexColumn val$columnVals;
            {
                this.val$columnVals = complexColumn;
            }

            public Class classOfObject() {
                return this.val$columnVals.getClazz();
            }

            public Object get() {
                return this.val$columnVals.getRowValue(QueryableIndexColumnSelectorFactory.this.offset.getOffset());
            }
        };
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.getColumnCapabilities(columnName);
        }
        return QueryableIndexStorageAdapter.getColumnCapabilites(this.index, columnName);
    }
}

