/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import com.google.inject.Inject;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.io.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.NullableAggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.NullableAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.NullableBufferAggregator;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.NullValueHandlingConfig;

public class NullHandlingHelper {
    private static String NULL_HANDLING_CONFIG_STRING = "druid.null.handling.useDefaultValueForNull";
    public static final Double ZERO_DOUBLE = 0.0;
    public static final Float ZERO_FLOAT = Float.valueOf(0.0f);
    public static final Long ZERO_LONG = 0L;
    @Inject
    private static NullValueHandlingConfig INSTANCE = new NullValueHandlingConfig(Boolean.valueOf(System.getProperty(NULL_HANDLING_CONFIG_STRING, "false")));

    public static boolean useDefaultValuesForNull() {
        return INSTANCE.isUseDefaultValuesForNull();
    }

    public static String nullToDefault(String value) {
        return INSTANCE.isUseDefaultValuesForNull() ? Strings.nullToEmpty(value) : value;
    }

    public static String defaultToNull(String value) {
        return INSTANCE.isUseDefaultValuesForNull() ? Strings.emptyToNull(value) : value;
    }

    public static boolean isNullOrDefault(String value) {
        return INSTANCE.isUseDefaultValuesForNull() ? Strings.isNullOrEmpty(value) : value == null;
    }

    public static Long nullToDefault(Long value) {
        return INSTANCE.isUseDefaultValuesForNull() && value == null ? ZERO_LONG : value;
    }

    public static Double nullToDefault(Double value) {
        return INSTANCE.isUseDefaultValuesForNull() && value == null ? ZERO_DOUBLE : value;
    }

    public static Float nullToDefault(Float value) {
        return INSTANCE.isUseDefaultValuesForNull() && value == null ? ZERO_FLOAT : value;
    }

    public static Aggregator getNullableAggregator(Aggregator aggregator, ColumnValueSelector selector) {
        return INSTANCE.isUseDefaultValuesForNull() ? aggregator : new NullableAggregator(aggregator, selector);
    }

    public static BufferAggregator getNullableAggregator(BufferAggregator aggregator, ColumnValueSelector selector) {
        return INSTANCE.isUseDefaultValuesForNull() ? aggregator : new NullableBufferAggregator(aggregator, selector);
    }

    public static AggregateCombiner getNullableCombiner(AggregateCombiner combiner) {
        return INSTANCE.isUseDefaultValuesForNull() ? combiner : new NullableAggregateCombiner(combiner);
    }

    public static int extraAggregatorBytes() {
        return NullHandlingHelper.useDefaultValuesForNull() ? 0 : 1;
    }
}

