/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.hive.druid.com.google.common.io.ByteSink;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.com.google.common.io.InputSupplier;
import org.apache.hive.druid.com.google.common.io.OutputSupplier;
import org.apache.hive.druid.io.druid.common.utils.SerializerUtils;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.io.druid.segment.data.CompressedDoublesIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.data.CompressedFloatsIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.data.CompressedLongsIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.data.DoubleSupplierSerializer;
import org.apache.hive.druid.io.druid.segment.data.FloatSupplierSerializer;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexedWriter;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.IndexedDoubles;
import org.apache.hive.druid.io.druid.segment.data.IndexedFloats;
import org.apache.hive.druid.io.druid.segment.data.IndexedLongs;
import org.apache.hive.druid.io.druid.segment.data.LongSupplierSerializer;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricSerde;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetrics;

public class MetricHolder {
    private static final byte[] version = new byte[]{0};
    private static final SerializerUtils serializerUtils = new SerializerUtils();
    private final String name;
    private final String typeName;
    private final MetricType type;
    CompressedLongsIndexedSupplier longType = null;
    CompressedFloatsIndexedSupplier floatType = null;
    CompressedDoublesIndexedSupplier doubleType = null;
    Indexed complexType = null;

    public static MetricHolder floatMetric(String name, CompressedFloatsIndexedSupplier column) {
        MetricHolder retVal = new MetricHolder(name, "float");
        retVal.floatType = column;
        return retVal;
    }

    public static MetricHolder complexMetric(String name, String typeName, Indexed column) {
        MetricHolder retVal = new MetricHolder(name, typeName);
        retVal.complexType = column;
        return retVal;
    }

    public static void writeComplexMetric(OutputSupplier<? extends OutputStream> outSupplier, String name, String typeName, GenericIndexedWriter column) throws IOException {
        try (OutputStream out = outSupplier.getOutput();){
            out.write(version);
            serializerUtils.writeString(out, name);
            serializerUtils.writeString(out, typeName);
            InputSupplier<InputStream> supplier = column.combineStreams();
            try (InputStream in = supplier.getInput();){
                ByteStreams.copy(in, out);
            }
        }
    }

    public static void writeFloatMetric(ByteSink outSupplier, String name, FloatSupplierSerializer column) throws IOException {
        outSupplier.write(version);
        serializerUtils.writeString(MetricHolder.toOutputSupplier(outSupplier), name);
        serializerUtils.writeString(MetricHolder.toOutputSupplier(outSupplier), "float");
        column.closeAndConsolidate(outSupplier);
    }

    public static void writeLongMetric(ByteSink outSupplier, String name, LongSupplierSerializer column) throws IOException {
        outSupplier.write(version);
        serializerUtils.writeString(MetricHolder.toOutputSupplier(outSupplier), name);
        serializerUtils.writeString(MetricHolder.toOutputSupplier(outSupplier), "long");
        column.closeAndConsolidate(outSupplier);
    }

    public static void writeDoubleMetric(ByteSink outSupplier, String name, DoubleSupplierSerializer column) throws IOException {
        outSupplier.write(version);
        serializerUtils.writeString(MetricHolder.toOutputSupplier(outSupplier), name);
        serializerUtils.writeString(MetricHolder.toOutputSupplier(outSupplier), "double");
        column.closeAndConsolidate(outSupplier);
    }

    public static MetricHolder fromByteBuffer(ByteBuffer buf, SmooshedFileMapper mapper) throws IOException {
        return MetricHolder.fromByteBuffer(buf, null, mapper);
    }

    public static MetricHolder fromByteBuffer(ByteBuffer buf, ObjectStrategy strategy, SmooshedFileMapper mapper) throws IOException {
        byte ver = buf.get();
        if (version[0] != ver) {
            throw new ISE("Unknown version[%s] of MetricHolder", ver);
        }
        String metricName = serializerUtils.readString(buf);
        String typeName = serializerUtils.readString(buf);
        MetricHolder holder = new MetricHolder(metricName, typeName);
        switch (holder.type) {
            case LONG: {
                holder.longType = CompressedLongsIndexedSupplier.fromByteBuffer(buf, ByteOrder.nativeOrder(), mapper);
                break;
            }
            case FLOAT: {
                holder.floatType = CompressedFloatsIndexedSupplier.fromByteBuffer(buf, ByteOrder.nativeOrder(), mapper);
                break;
            }
            case DOUBLE: {
                holder.doubleType = CompressedDoublesIndexedSupplier.fromByteBuffer(buf, ByteOrder.nativeOrder(), mapper);
                break;
            }
            case COMPLEX: {
                if (strategy != null) {
                    holder.complexType = GenericIndexed.read(buf, strategy, mapper);
                    break;
                }
                ComplexMetricSerde serdeForType = ComplexMetrics.getSerdeForType(holder.getTypeName());
                if (serdeForType == null) {
                    throw new ISE("Unknown type[%s], cannot load.", holder.getTypeName());
                }
                holder.complexType = GenericIndexed.read(buf, serdeForType.getObjectStrategy());
            }
        }
        return holder;
    }

    private static OutputSupplier<? extends OutputStream> toOutputSupplier(final ByteSink sink) {
        return new OutputSupplier<OutputStream>(){

            @Override
            public OutputStream getOutput() throws IOException {
                return sink.openStream();
            }
        };
    }

    private MetricHolder(String name, String typeName) {
        this.name = name;
        this.typeName = typeName;
        this.type = MetricType.determineType(typeName);
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public MetricType getType() {
        return this.type;
    }

    public IndexedLongs getLongType() {
        this.assertType(MetricType.LONG);
        return this.longType.get();
    }

    public IndexedFloats getFloatType() {
        this.assertType(MetricType.FLOAT);
        return this.floatType.get();
    }

    public IndexedDoubles getDoubleType() {
        this.assertType(MetricType.DOUBLE);
        return this.doubleType.get();
    }

    public Indexed getComplexType() {
        this.assertType(MetricType.COMPLEX);
        return this.complexType;
    }

    private void assertType(MetricType type) {
        if (this.type != type) {
            throw new IAE("type[%s] cannot be cast to [%s]", new Object[]{this.typeName, type});
        }
    }

    public static enum MetricType {
        LONG,
        FLOAT,
        DOUBLE,
        COMPLEX;


        static MetricType determineType(String typeName) {
            if ("long".equalsIgnoreCase(typeName)) {
                return LONG;
            }
            if ("float".equalsIgnoreCase(typeName)) {
                return FLOAT;
            }
            if ("double".equalsIgnoreCase(typeName)) {
                return DOUBLE;
            }
            return COMPLEX;
        }
    }
}

