/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.java.util.common.io.Closer;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.DimensionMergerV9;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.IndexableAdapter;
import org.apache.hive.druid.io.druid.segment.LongColumnSerializer;
import org.apache.hive.druid.io.druid.segment.ProgressIndicator;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ColumnDescriptor;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.serde.LongGenericColumnPartSerdeV2;

public class LongDimensionMergerV9
implements DimensionMergerV9<Long> {
    private static final Logger log = new Logger(LongDimensionMergerV9.class);
    protected String dimensionName;
    protected ProgressIndicator progress;
    protected final IndexSpec indexSpec;
    protected ColumnCapabilities capabilities;
    protected final File outDir;
    protected IOPeon ioPeon;
    protected LongColumnSerializer serializer;

    public LongDimensionMergerV9(String dimensionName, IndexSpec indexSpec, File outDir, IOPeon ioPeon, ColumnCapabilities capabilities, ProgressIndicator progress) {
        this.dimensionName = dimensionName;
        this.indexSpec = indexSpec;
        this.capabilities = capabilities;
        this.outDir = outDir;
        this.ioPeon = ioPeon;
        this.progress = progress;
        try {
            this.setupEncodedValueWriter();
        }
        catch (IOException ioe) {
            Throwables.propagate(ioe);
        }
    }

    protected void setupEncodedValueWriter() throws IOException {
        CompressedObjectStrategy.CompressionStrategy metCompression = this.indexSpec.getMetricCompression();
        CompressionFactory.LongEncodingStrategy longEncoding = this.indexSpec.getLongEncoding();
        this.serializer = LongColumnSerializer.create(this.ioPeon, this.dimensionName, metCompression, longEncoding, this.indexSpec.getBitmapSerdeFactory());
        this.serializer.open();
    }

    @Override
    public void writeMergedValueMetadata(List<IndexableAdapter> adapters) throws IOException {
    }

    @Override
    public Long convertSegmentRowValuesToMergedRowValues(Long segmentRow, int segmentIndexNumber) {
        return segmentRow;
    }

    @Override
    public void processMergedRow(Long rowValues) throws IOException {
        this.serializer.serialize(rowValues);
    }

    @Override
    public void writeIndexes(List<IntBuffer> segmentRowNumConversions, Closer closer) throws IOException {
    }

    @Override
    public boolean canSkip() {
        return false;
    }

    @Override
    public ColumnDescriptor makeColumnDescriptor() throws IOException {
        this.serializer.close();
        ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
        builder.setValueType(ValueType.LONG);
        builder.addSerde(LongGenericColumnPartSerdeV2.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withBitmapSerdeFactory(this.indexSpec.getBitmapSerdeFactory()).withDelegate(this.serializer).build());
        return builder.build();
    }
}

