/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.ConciseBitmapSerdeFactory;

public class IndexSpec {
    public static final CompressedObjectStrategy.CompressionStrategy DEFAULT_METRIC_COMPRESSION = CompressedObjectStrategy.DEFAULT_COMPRESSION_STRATEGY;
    public static final CompressedObjectStrategy.CompressionStrategy DEFAULT_DIMENSION_COMPRESSION = CompressedObjectStrategy.DEFAULT_COMPRESSION_STRATEGY;
    public static final CompressionFactory.LongEncodingStrategy DEFAULT_LONG_ENCODING = CompressionFactory.DEFAULT_LONG_ENCODING_STRATEGY;
    private static final Set<CompressedObjectStrategy.CompressionStrategy> METRIC_COMPRESSION = Sets.newHashSet(Arrays.asList(CompressedObjectStrategy.CompressionStrategy.values()));
    private static final Set<CompressedObjectStrategy.CompressionStrategy> DIMENSION_COMPRESSION = Sets.newHashSet(Arrays.asList(CompressedObjectStrategy.CompressionStrategy.noNoneValues()));
    private static final Set<CompressionFactory.LongEncodingStrategy> LONG_ENCODING_NAMES = Sets.newHashSet(Arrays.asList(CompressionFactory.LongEncodingStrategy.values()));
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final CompressedObjectStrategy.CompressionStrategy dimensionCompression;
    private final CompressedObjectStrategy.CompressionStrategy metricCompression;
    private final CompressionFactory.LongEncodingStrategy longEncoding;

    public IndexSpec() {
        this(null, null, null, null);
    }

    @JsonCreator
    public IndexSpec(@JsonProperty(value="bitmap") BitmapSerdeFactory bitmapSerdeFactory, @JsonProperty(value="dimensionCompression") CompressedObjectStrategy.CompressionStrategy dimensionCompression, @JsonProperty(value="metricCompression") CompressedObjectStrategy.CompressionStrategy metricCompression, @JsonProperty(value="longEncoding") CompressionFactory.LongEncodingStrategy longEncoding) {
        Preconditions.checkArgument(dimensionCompression == null || DIMENSION_COMPRESSION.contains((Object)dimensionCompression), "Unknown compression type[%s]", new Object[]{dimensionCompression});
        Preconditions.checkArgument(metricCompression == null || METRIC_COMPRESSION.contains((Object)metricCompression), "Unknown compression type[%s]", new Object[]{metricCompression});
        Preconditions.checkArgument(longEncoding == null || LONG_ENCODING_NAMES.contains((Object)longEncoding), "Unknown long encoding type[%s]", new Object[]{longEncoding});
        this.bitmapSerdeFactory = bitmapSerdeFactory != null ? bitmapSerdeFactory : new ConciseBitmapSerdeFactory();
        this.dimensionCompression = dimensionCompression == null ? DEFAULT_DIMENSION_COMPRESSION : dimensionCompression;
        this.metricCompression = metricCompression == null ? DEFAULT_METRIC_COMPRESSION : metricCompression;
        this.longEncoding = longEncoding == null ? DEFAULT_LONG_ENCODING : longEncoding;
    }

    @JsonProperty(value="bitmap")
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    @JsonProperty
    public CompressedObjectStrategy.CompressionStrategy getDimensionCompression() {
        return this.dimensionCompression;
    }

    @JsonProperty
    public CompressedObjectStrategy.CompressionStrategy getMetricCompression() {
        return this.metricCompression;
    }

    @JsonProperty
    public CompressionFactory.LongEncodingStrategy getLongEncoding() {
        return this.longEncoding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSpec indexSpec = (IndexSpec)o;
        return Objects.equals(this.bitmapSerdeFactory, indexSpec.bitmapSerdeFactory) && this.dimensionCompression == indexSpec.dimensionCompression && this.metricCompression == indexSpec.metricCompression && this.longEncoding == indexSpec.longEncoding;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bitmapSerdeFactory, this.dimensionCompression, this.metricCompression, this.longEncoding});
    }

    public String toString() {
        return "IndexSpec{bitmapSerdeFactory=" + this.bitmapSerdeFactory + ", dimensionCompression=" + (Object)((Object)this.dimensionCompression) + ", metricCompression=" + (Object)((Object)this.metricCompression) + ", longEncoding=" + (Object)((Object)this.longEncoding) + '}';
    }
}

