/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.io.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.DimensionIndexer;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.FloatWrappingDimensionSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.TimeAndDimsHolder;

public class FloatDimensionIndexer
implements DimensionIndexer<Float, Float, Float> {
    public static final Comparator FLOAT_COMPARATOR = Comparators.naturalNullsFirst();

    @Override
    public ValueType getValueType() {
        return ValueType.FLOAT;
    }

    @Override
    public Float processRowValsToUnsortedEncodedKeyComponent(Object dimValues) {
        if (dimValues instanceof List) {
            throw new UnsupportedOperationException("Numeric columns do not support multivalue rows.");
        }
        return DimensionHandlerUtils.convertObjectToFloat(dimValues);
    }

    @Override
    public Float getSortedEncodedValueFromUnsorted(Float unsortedIntermediateValue) {
        return unsortedIntermediateValue;
    }

    @Override
    public Float getUnsortedEncodedValueFromSorted(Float sortedIntermediateValue) {
        return sortedIntermediateValue;
    }

    @Override
    public Indexed<Float> getSortedIndexedValues() {
        throw new UnsupportedOperationException("Numeric columns do not support value dictionaries.");
    }

    @Override
    public Float getMinValue() {
        return Float.valueOf(Float.NEGATIVE_INFINITY);
    }

    @Override
    public Float getMaxValue() {
        return Float.valueOf(Float.POSITIVE_INFINITY);
    }

    @Override
    public int getCardinality() {
        return -1;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec spec, TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        return new FloatWrappingDimensionSelector(this.makeFloatColumnSelector(currEntry, desc), spec.getExtractionFn());
    }

    @Override
    public LongColumnSelector makeLongColumnSelector(final TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final int dimIndex = desc.getIndex();
        class IndexerLongColumnSelector
        implements LongColumnSelector {
            IndexerLongColumnSelector() {
            }

            @Override
            public long getLong() {
                Object[] dims = currEntry.getKey().getDims();
                if (dimIndex >= dims.length) {
                    return 0L;
                }
                return DimensionHandlerUtils.nullToZero((Float)dims[dimIndex]).longValue();
            }

            @Override
            public boolean isNull() {
                Object[] dims = currEntry.getKey().getDims();
                return dimIndex >= dims.length || dims[dimIndex] == null;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
        return new IndexerLongColumnSelector();
    }

    @Override
    public FloatColumnSelector makeFloatColumnSelector(final TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final int dimIndex = desc.getIndex();
        class IndexerFloatColumnSelector
        implements FloatColumnSelector {
            IndexerFloatColumnSelector() {
            }

            @Override
            public float getFloat() {
                Object[] dims = currEntry.getKey().getDims();
                if (dimIndex >= dims.length) {
                    return 0.0f;
                }
                return DimensionHandlerUtils.nullToZero((Float)dims[dimIndex]).floatValue();
            }

            @Override
            public boolean isNull() {
                Object[] dims = currEntry.getKey().getDims();
                return dimIndex >= dims.length || dims[dimIndex] == null;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
        return new IndexerFloatColumnSelector();
    }

    @Override
    public DoubleColumnSelector makeDoubleColumnSelector(final TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final int dimIndex = desc.getIndex();
        class IndexerDoubleColumnSelector
        implements DoubleColumnSelector {
            IndexerDoubleColumnSelector() {
            }

            @Override
            public double getDouble() {
                Object[] dims = currEntry.getKey().getDims();
                if (dimIndex >= dims.length) {
                    return 0.0;
                }
                return DimensionHandlerUtils.nullToZero((Float)dims[dimIndex]).floatValue();
            }

            @Override
            public boolean isNull() {
                Object[] dims = currEntry.getKey().getDims();
                return dimIndex >= dims.length || dims[dimIndex] == null;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
        return new IndexerDoubleColumnSelector();
    }

    @Override
    public int compareUnsortedEncodedKeyComponents(@Nullable Float lhs, @Nullable Float rhs) {
        return FLOAT_COMPARATOR.compare(lhs, rhs);
    }

    @Override
    public boolean checkUnsortedEncodedKeyComponentsEqual(@Nullable Float lhs, @Nullable Float rhs) {
        return Objects.equals(lhs, rhs);
    }

    @Override
    public int getUnsortedEncodedKeyComponentHashCode(@Nullable Float key) {
        return DimensionHandlerUtils.nullToZero(key).hashCode();
    }

    @Override
    public Object convertUnsortedEncodedKeyComponentToActualArrayOrList(Float key, boolean asList) {
        return key;
    }

    @Override
    public Float convertUnsortedEncodedKeyComponentToSortedEncodedKeyComponent(Float key) {
        return key;
    }

    @Override
    public void fillBitmapsFromUnsortedEncodedKeyComponent(Float key, int rowNum, MutableBitmap[] bitmapIndexes, BitmapFactory factory) {
        throw new UnsupportedOperationException("Numeric columns do not support bitmaps.");
    }
}

