/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.hive.druid.io.druid.segment.DimensionHandler;
import org.apache.hive.druid.io.druid.segment.DimensionIndexer;
import org.apache.hive.druid.io.druid.segment.DimensionMergerV9;
import org.apache.hive.druid.io.druid.segment.FloatDimensionIndexer;
import org.apache.hive.druid.io.druid.segment.FloatDimensionMergerV9;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.ProgressIndicator;
import org.apache.hive.druid.io.druid.segment.SegmentValidationException;
import org.apache.hive.druid.io.druid.segment.column.Column;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.GenericColumn;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.Indexed;

public class FloatDimensionHandler
implements DimensionHandler<Float, Float, Float> {
    private final String dimensionName;

    public FloatDimensionHandler(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Override
    public DimensionIndexer<Float, Float, Float> makeIndexer() {
        return new FloatDimensionIndexer();
    }

    @Override
    public DimensionMergerV9<Float> makeMerger(IndexSpec indexSpec, File outDir, IOPeon ioPeon, ColumnCapabilities capabilities, ProgressIndicator progress) throws IOException {
        return new FloatDimensionMergerV9(this.dimensionName, indexSpec, outDir, ioPeon, capabilities, progress);
    }

    @Override
    public int getLengthOfEncodedKeyComponent(Float dimVals) {
        return 1;
    }

    @Override
    public int compareSortedEncodedKeyComponents(Float lhs, Float rhs) {
        return lhs.compareTo(rhs);
    }

    @Override
    public void validateSortedEncodedKeyComponents(Float lhs, Float rhs, Indexed<Float> lhsEncodings, Indexed<Float> rhsEncodings) throws SegmentValidationException {
        if (!lhs.equals(rhs)) {
            throw new SegmentValidationException("Dim [%s] value not equal. Expected [%s] found [%s]", this.dimensionName, lhs, rhs);
        }
    }

    @Override
    public Closeable getSubColumn(Column column) {
        return column.getGenericColumn();
    }

    @Override
    public Float getEncodedKeyComponentFromColumn(Closeable column, int currRow) {
        return Float.valueOf(((GenericColumn)column).getFloatSingleValueRow(currRow));
    }
}

