/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.QueryMetrics;
import org.apache.hive.druid.io.druid.query.TableDataSource;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.InDimFilter;
import org.apache.hive.druid.io.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.io.druid.query.spec.LegacySegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.io.druid.query.topn.NumericTopNMetricSpec;
import org.apache.hive.druid.io.druid.query.topn.TopNMetricSpec;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.segment.VirtualColumn;
import org.apache.hive.druid.io.druid.segment.VirtualColumns;
import org.joda.time.Interval;

public class TopNQueryBuilder {
    private DataSource dataSource;
    private VirtualColumns virtualColumns;
    private DimensionSpec dimensionSpec;
    private TopNMetricSpec topNMetricSpec;
    private int threshold;
    private QuerySegmentSpec querySegmentSpec;
    private DimFilter dimFilter;
    private Granularity granularity;
    private List<AggregatorFactory> aggregatorSpecs;
    private List<PostAggregator> postAggregatorSpecs;
    private Map<String, Object> context;
    private QueryMetrics<?> queryMetrics;

    public TopNQueryBuilder() {
        this.dataSource = null;
        this.virtualColumns = null;
        this.dimensionSpec = null;
        this.topNMetricSpec = null;
        this.threshold = 0;
        this.querySegmentSpec = null;
        this.dimFilter = null;
        this.granularity = Granularities.ALL;
        this.aggregatorSpecs = Lists.newArrayList();
        this.postAggregatorSpecs = Lists.newArrayList();
        this.context = null;
    }

    public TopNQueryBuilder(TopNQuery query) {
        this.dataSource = query.getDataSource();
        this.virtualColumns = query.getVirtualColumns();
        this.dimensionSpec = query.getDimensionSpec();
        this.topNMetricSpec = query.getTopNMetricSpec();
        this.threshold = query.getThreshold();
        this.querySegmentSpec = query.getQuerySegmentSpec();
        this.dimFilter = query.getDimensionsFilter();
        this.granularity = query.getGranularity();
        this.aggregatorSpecs = query.getAggregatorSpecs();
        this.postAggregatorSpecs = query.getPostAggregatorSpecs();
        this.context = query.getContext();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    public DimensionSpec getDimensionSpec() {
        return this.dimensionSpec;
    }

    public TopNMetricSpec getTopNMetricSpec() {
        return this.topNMetricSpec;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public QuerySegmentSpec getQuerySegmentSpec() {
        return this.querySegmentSpec;
    }

    public DimFilter getDimFilter() {
        return this.dimFilter;
    }

    public Granularity getGranularity() {
        return this.granularity;
    }

    public List<AggregatorFactory> getAggregatorSpecs() {
        return this.aggregatorSpecs;
    }

    public List<PostAggregator> getPostAggregatorSpecs() {
        return this.postAggregatorSpecs;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public TopNQuery build() {
        return new TopNQuery(this.dataSource, this.virtualColumns, this.dimensionSpec, this.topNMetricSpec, this.threshold, this.querySegmentSpec, this.dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.context);
    }

    @Deprecated
    public TopNQueryBuilder copy(TopNQuery query) {
        return new TopNQueryBuilder(query);
    }

    @Deprecated
    public TopNQueryBuilder copy(TopNQueryBuilder builder) {
        return new TopNQueryBuilder().dataSource(builder.dataSource).virtualColumns(builder.virtualColumns).dimension(builder.dimensionSpec).metric(builder.topNMetricSpec).threshold(builder.threshold).intervals(builder.querySegmentSpec).filters(builder.dimFilter).granularity(builder.granularity).aggregators(builder.aggregatorSpecs).postAggregators(builder.postAggregatorSpecs).context(builder.context);
    }

    public TopNQueryBuilder dataSource(String d) {
        this.dataSource = new TableDataSource(d);
        return this;
    }

    public TopNQueryBuilder virtualColumns(VirtualColumns virtualColumns) {
        this.virtualColumns = virtualColumns;
        return this;
    }

    public TopNQueryBuilder virtualColumns(List<VirtualColumn> virtualColumns) {
        return this.virtualColumns(VirtualColumns.create(virtualColumns));
    }

    public TopNQueryBuilder virtualColumns(VirtualColumn ... virtualColumns) {
        return this.virtualColumns(VirtualColumns.create(Arrays.asList(virtualColumns)));
    }

    public TopNQueryBuilder dataSource(DataSource d) {
        this.dataSource = d;
        return this;
    }

    public TopNQueryBuilder dimension(String d) {
        return this.dimension(d, null);
    }

    public TopNQueryBuilder dimension(String d, String outputName) {
        return this.dimension(new DefaultDimensionSpec(d, outputName));
    }

    public TopNQueryBuilder dimension(DimensionSpec d) {
        this.dimensionSpec = d;
        return this;
    }

    public TopNQueryBuilder metric(String s) {
        return this.metric(new NumericTopNMetricSpec(s));
    }

    public TopNQueryBuilder metric(TopNMetricSpec t) {
        this.topNMetricSpec = t;
        return this;
    }

    public TopNQueryBuilder threshold(int i) {
        this.threshold = i;
        return this;
    }

    public TopNQueryBuilder intervals(QuerySegmentSpec q) {
        this.querySegmentSpec = q;
        return this;
    }

    public TopNQueryBuilder intervals(String s) {
        this.querySegmentSpec = new LegacySegmentSpec(s);
        return this;
    }

    public TopNQueryBuilder intervals(List<Interval> l) {
        this.querySegmentSpec = new LegacySegmentSpec((Object)l);
        return this;
    }

    public TopNQueryBuilder filters(String dimensionName, String value) {
        this.dimFilter = new SelectorDimFilter(dimensionName, value, null);
        return this;
    }

    public TopNQueryBuilder filters(String dimensionName, String value, String ... values) {
        this.dimFilter = new InDimFilter(dimensionName, Lists.asList(value, values), null);
        return this;
    }

    public TopNQueryBuilder filters(DimFilter f) {
        this.dimFilter = f;
        return this;
    }

    public TopNQueryBuilder granularity(String g) {
        this.granularity = Granularity.fromString(g);
        return this;
    }

    public TopNQueryBuilder granularity(Granularity g) {
        this.granularity = g;
        return this;
    }

    public TopNQueryBuilder aggregators(List<? extends AggregatorFactory> a) {
        this.aggregatorSpecs = a;
        return this;
    }

    public TopNQueryBuilder postAggregators(List<PostAggregator> p) {
        this.postAggregatorSpecs = p;
        return this;
    }

    public TopNQueryBuilder context(Map<String, Object> c) {
        this.context = c;
        return this;
    }

    public TopNQueryBuilder queryMetrics(QueryMetrics<?> m) {
        this.queryMetrics = m;
        return this;
    }
}

