/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.search.search;

import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.util.Arrays;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.java.util.common.guava.Accumulator;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.query.ColumnSelectorPlus;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.search.SearchQueryRunner;
import org.apache.hive.druid.io.druid.query.search.search.SearchHit;
import org.apache.hive.druid.io.druid.query.search.search.SearchQuery;
import org.apache.hive.druid.io.druid.query.search.search.SearchQueryExecutor;
import org.apache.hive.druid.io.druid.query.search.search.SearchStrategy;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.VirtualColumns;
import org.joda.time.Interval;

public class CursorOnlyStrategy
extends SearchStrategy {
    public static final String NAME = "cursorOnly";

    public static CursorOnlyStrategy of(SearchQuery query) {
        return new CursorOnlyStrategy(query);
    }

    private CursorOnlyStrategy(SearchQuery query) {
        super(query);
    }

    @Override
    public List<SearchQueryExecutor> getExecutionPlan(SearchQuery query, Segment segment) {
        StorageAdapter adapter = segment.asStorageAdapter();
        List<DimensionSpec> dimensionSpecs = CursorOnlyStrategy.getDimsToSearch(adapter.getAvailableDimensions(), query.getDimensions());
        return ImmutableList.of(new CursorBasedExecutor(query, segment, this.filter, this.interval, dimensionSpecs));
    }

    public static class CursorBasedExecutor
    extends SearchQueryExecutor {
        protected Filter filter;
        protected Interval interval;

        public CursorBasedExecutor(SearchQuery query, Segment segment, Filter filter, Interval interval, List<DimensionSpec> dimensionSpecs) {
            super(query, segment, dimensionSpecs);
            this.filter = filter;
            this.interval = interval;
        }

        @Override
        public Object2IntRBTreeMap<SearchHit> execute(final int limit) {
            StorageAdapter adapter = this.segment.asStorageAdapter();
            Sequence<Cursor> cursors = adapter.makeCursors(this.filter, this.interval, VirtualColumns.EMPTY, this.query.getGranularity(), this.query.isDescending(), null);
            Object2IntRBTreeMap<SearchHit> retVal = new Object2IntRBTreeMap<SearchHit>(this.query.getSort().getComparator());
            retVal.defaultReturnValue(0);
            cursors.accumulate(retVal, new Accumulator<Object2IntRBTreeMap<SearchHit>, Cursor>(){

                @Override
                public Object2IntRBTreeMap<SearchHit> accumulate(Object2IntRBTreeMap<SearchHit> set, Cursor cursor) {
                    if (set.size() >= limit) {
                        return set;
                    }
                    List<ColumnSelectorPlus<SearchQueryRunner.SearchColumnSelectorStrategy>> selectorPlusList = Arrays.asList(DimensionHandlerUtils.createColumnSelectorPluses(SearchQueryRunner.SEARCH_COLUMN_SELECTOR_STRATEGY_FACTORY, dimsToSearch, cursor.getColumnSelectorFactory()));
                    while (!cursor.isDone()) {
                        for (ColumnSelectorPlus<SearchQueryRunner.SearchColumnSelectorStrategy> selectorPlus : selectorPlusList) {
                            selectorPlus.getColumnSelectorStrategy().updateSearchResultSet(selectorPlus.getOutputName(), selectorPlus.getSelector(), searchQuerySpec, limit, set);
                            if (set.size() < limit) continue;
                            return set;
                        }
                        cursor.advance();
                    }
                    return set;
                }
            });
            return retVal;
        }
    }
}

