/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.metadata;

import java.util.EnumSet;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.joda.time.Period;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public class SegmentMetadataQueryConfig {
    private static final String DEFAULT_PERIOD_STRING = "P1W";
    private static final PeriodFormatter ISO_FORMATTER = ISOPeriodFormat.standard();
    private static final EnumSet<SegmentMetadataQuery.AnalysisType> DEFAULT_ANALYSIS_TYPES = EnumSet.of(SegmentMetadataQuery.AnalysisType.CARDINALITY, SegmentMetadataQuery.AnalysisType.INTERVAL, SegmentMetadataQuery.AnalysisType.MINMAX);
    @JsonProperty
    private Period defaultHistory = ISO_FORMATTER.parsePeriod("P1W");
    @JsonProperty
    private EnumSet<SegmentMetadataQuery.AnalysisType> defaultAnalysisTypes = DEFAULT_ANALYSIS_TYPES;

    public SegmentMetadataQueryConfig(String period) {
        this.defaultHistory = ISO_FORMATTER.parsePeriod(period);
    }

    public SegmentMetadataQueryConfig() {
    }

    public Period getDefaultHistory() {
        return this.defaultHistory;
    }

    public void setDefaultHistory(String period) {
        this.defaultHistory = ISO_FORMATTER.parsePeriod(period);
    }

    public EnumSet<SegmentMetadataQuery.AnalysisType> getDefaultAnalysisTypes() {
        return this.defaultAnalysisTypes;
    }

    public void setDefaultAnalysisTypes(EnumSet<SegmentMetadataQuery.AnalysisType> defaultAnalysisTypes) {
        this.defaultAnalysisTypes = defaultAnalysisTypes;
    }
}

