/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.lookup;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.concurrent.Execs;
import org.apache.hive.druid.io.druid.concurrent.LifecycleLock;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.io.druid.query.lookup.LookupBean;
import org.apache.hive.druid.io.druid.query.lookup.LookupConfig;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.hive.druid.io.druid.query.lookup.LookupSnapshotTaker;
import org.apache.hive.druid.io.druid.query.lookup.LookupsState;

@ManageLifecycle
public class LookupReferencesManager {
    private static final EmittingLogger LOG = new EmittingLogger(LookupReferencesManager.class);
    @VisibleForTesting
    final AtomicReference<LookupUpdateState> stateRef = new AtomicReference();
    @VisibleForTesting
    final LookupSnapshotTaker lookupSnapshotTaker;
    @VisibleForTesting
    final LifecycleLock lifecycleLock = new LifecycleLock();
    @VisibleForTesting
    Thread mainThread;
    private final boolean testMode;

    @Inject
    public LookupReferencesManager(LookupConfig lookupConfig, @Json ObjectMapper objectMapper) {
        this(lookupConfig, objectMapper, false);
    }

    @VisibleForTesting
    LookupReferencesManager(LookupConfig lookupConfig, ObjectMapper objectMapper, boolean testMode) {
        this.lookupSnapshotTaker = Strings.isNullOrEmpty(lookupConfig.getSnapshotWorkingDir()) ? null : new LookupSnapshotTaker(objectMapper, lookupConfig.getSnapshotWorkingDir());
        this.testMode = testMode;
    }

    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        try {
            LOG.info("LookupReferencesManager is starting.", new Object[0]);
            this.loadSnapshotAndInitStateRef();
            if (!this.testMode) {
                this.mainThread = Execs.makeThread("LookupReferencesManager-MainThread", new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!LookupReferencesManager.this.lifecycleLock.awaitStarted()) {
                                LOG.error("WTF! lifecycle not started, lookup update notices will not be handled.", new Object[0]);
                                return;
                            }
                            while (!Thread.interrupted() && LookupReferencesManager.this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS)) {
                                try {
                                    LookupReferencesManager.this.handlePendingNotices();
                                    LockSupport.parkNanos(LookupReferencesManager.this, TimeUnit.MINUTES.toNanos(1L));
                                }
                                catch (Throwable t) {
                                    LOG.makeAlert(t, "Error occured while lookup notice handling.", new Object[0]).emit();
                                }
                            }
                        }
                        catch (Throwable t) {
                            LOG.error(t, "Error while waiting for lifecycle start. lookup updates notices will not be handled", new Object[0]);
                        }
                        finally {
                            LOG.info("Lookup Management loop exited, Lookup notices are not handled anymore.", new Object[0]);
                        }
                    }
                }, true);
                this.mainThread.start();
            }
            LOG.info("LookupReferencesManager is started.", new Object[0]);
            this.lifecycleLock.started();
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @VisibleForTesting
    void handlePendingNotices() {
        if (this.stateRef.get().pendingNotices.isEmpty()) {
            return;
        }
        LookupUpdateState swappedState = this.atomicallyUpdateStateRef(oldState -> new LookupUpdateState(((LookupUpdateState)oldState).lookupMap, ImmutableList.of(), ((LookupUpdateState)oldState).pendingNotices));
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>(swappedState.lookupMap);
        for (Notice notice : swappedState.noticesBeingHandled) {
            try {
                notice.handle(lookupMap);
            }
            catch (Exception ex) {
                LOG.error(ex, "Exception occured while handling lookup notice [%s].", notice);
                LOG.makeAlert("Exception occured while handling lookup notice, with message [%s].", ex.getMessage()).emit();
            }
        }
        this.takeSnapshot(lookupMap);
        ImmutableMap<String, LookupExtractorFactoryContainer> immutableLookupMap = ImmutableMap.copyOf(lookupMap);
        this.atomicallyUpdateStateRef(oldState -> new LookupUpdateState(immutableLookupMap, ((LookupUpdateState)oldState).pendingNotices, ImmutableList.of()));
    }

    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        LOG.info("LookupReferencesManager is stopping.", new Object[0]);
        if (!this.testMode) {
            this.mainThread.interrupt();
            try {
                this.mainThread.join();
            }
            catch (InterruptedException ex) {
                throw new ISE("failed to stop, mainThread couldn't finish.", new Object[0]);
            }
        }
        for (Map.Entry e : this.stateRef.get().lookupMap.entrySet()) {
            try {
                LOG.info("Closing lookup [%s]", e.getKey());
                if (((LookupExtractorFactoryContainer)e.getValue()).getLookupExtractorFactory().close()) continue;
                LOG.error("Failed to close lookup [%s].", e.getKey());
            }
            catch (Exception ex) {
                LOG.error(ex, "Failed to close lookup [%s].", e.getKey());
            }
        }
        LOG.info("LookupReferencesManager is stopped.", new Object[0]);
    }

    public void add(String lookupName, LookupExtractorFactoryContainer lookupExtractorFactoryContainer) {
        Preconditions.checkState(this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.addNotice(new LoadNotice(lookupName, lookupExtractorFactoryContainer));
    }

    public void remove(String lookupName) {
        Preconditions.checkState(this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.addNotice(new DropNotice(lookupName));
    }

    private void addNotice(Notice notice) {
        this.atomicallyUpdateStateRef(oldState -> {
            if (((LookupUpdateState)oldState).pendingNotices.size() > 10000) {
                throw new ISE("There are too many [%d] pendingNotices.", ((LookupUpdateState)oldState).pendingNotices.size());
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)((LookupUpdateState)oldState).pendingNotices);
            builder.add(notice);
            return new LookupUpdateState(((LookupUpdateState)oldState).lookupMap, (ImmutableList<Notice>)builder.build(), ((LookupUpdateState)oldState).noticesBeingHandled);
        });
        LockSupport.unpark(this.mainThread);
    }

    @Nullable
    public LookupExtractorFactoryContainer get(String lookupName) {
        Preconditions.checkState(this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        return (LookupExtractorFactoryContainer)this.stateRef.get().lookupMap.get(lookupName);
    }

    public LookupsState<LookupExtractorFactoryContainer> getAllLookupsState() {
        Preconditions.checkState(this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        LookupUpdateState lookupUpdateState = this.stateRef.get();
        HashMap<String, LookupExtractorFactoryContainer> lookupsToLoad = new HashMap<String, LookupExtractorFactoryContainer>();
        HashSet<String> lookupsToDrop = new HashSet<String>();
        this.updateToLoadAndDrop(lookupUpdateState.noticesBeingHandled, lookupsToLoad, lookupsToDrop);
        this.updateToLoadAndDrop(lookupUpdateState.pendingNotices, lookupsToLoad, lookupsToDrop);
        return new LookupsState<LookupExtractorFactoryContainer>(lookupUpdateState.lookupMap, lookupsToLoad, lookupsToDrop);
    }

    private void updateToLoadAndDrop(List<Notice> notices, Map<String, LookupExtractorFactoryContainer> lookupsToLoad, Set<String> lookupsToDrop) {
        for (Notice notice : notices) {
            if (notice instanceof LoadNotice) {
                LoadNotice loadNotice = (LoadNotice)notice;
                lookupsToLoad.put(loadNotice.lookupName, loadNotice.lookupExtractorFactoryContainer);
                lookupsToDrop.remove(loadNotice.lookupName);
                continue;
            }
            if (notice instanceof DropNotice) {
                DropNotice dropNotice = (DropNotice)notice;
                lookupsToDrop.add(dropNotice.lookupName);
                lookupsToLoad.remove(dropNotice.lookupName);
                continue;
            }
            throw new ISE("Unknown Notice type [%s].", notice.getClass().getName());
        }
    }

    private void takeSnapshot(Map<String, LookupExtractorFactoryContainer> lookupMap) {
        if (this.lookupSnapshotTaker != null) {
            ArrayList<LookupBean> lookups = new ArrayList<LookupBean>(lookupMap.size());
            for (Map.Entry<String, LookupExtractorFactoryContainer> e : lookupMap.entrySet()) {
                lookups.add(new LookupBean(e.getKey(), null, e.getValue()));
            }
            this.lookupSnapshotTaker.takeSnapshot(lookups);
        }
    }

    private void loadSnapshotAndInitStateRef() {
        if (this.lookupSnapshotTaker != null) {
            ImmutableMap.Builder<String, LookupExtractorFactoryContainer> builder = ImmutableMap.builder();
            List<LookupBean> lookupBeanList = this.lookupSnapshotTaker.pullExistingSnapshot();
            for (LookupBean lookupBean : lookupBeanList) {
                LookupExtractorFactoryContainer container = lookupBean.getContainer();
                if (container.getLookupExtractorFactory().start()) {
                    builder.put(lookupBean.getName(), container);
                    continue;
                }
                throw new ISE("Failed to start lookup [%s]:[%s]", lookupBean.getName(), container);
            }
            this.stateRef.set(new LookupUpdateState(builder.build(), ImmutableList.of(), ImmutableList.of()));
        } else {
            this.stateRef.set(new LookupUpdateState(ImmutableMap.of(), ImmutableList.of(), ImmutableList.of()));
        }
    }

    private LookupUpdateState atomicallyUpdateStateRef(Function<LookupUpdateState, LookupUpdateState> fn) {
        LookupUpdateState newState;
        LookupUpdateState old;
        while (!this.stateRef.compareAndSet(old = this.stateRef.get(), newState = fn.apply(old))) {
        }
        return newState;
    }

    private static class LookupUpdateState {
        private final ImmutableMap<String, LookupExtractorFactoryContainer> lookupMap;
        private final ImmutableList<Notice> pendingNotices;
        private final ImmutableList<Notice> noticesBeingHandled;

        LookupUpdateState(ImmutableMap<String, LookupExtractorFactoryContainer> lookupMap, ImmutableList<Notice> pendingNotices, ImmutableList<Notice> noticesBeingHandled) {
            this.lookupMap = lookupMap;
            this.pendingNotices = pendingNotices;
            this.noticesBeingHandled = noticesBeingHandled;
        }
    }

    private static class DropNotice
    implements Notice {
        private final String lookupName;

        public DropNotice(String lookupName) {
            this.lookupName = lookupName;
        }

        @Override
        public void handle(Map<String, LookupExtractorFactoryContainer> lookupMap) {
            LookupExtractorFactoryContainer lookupExtractorFactoryContainer = lookupMap.remove(this.lookupName);
            if (lookupExtractorFactoryContainer != null) {
                LOG.debug("Removed lookup [%s] with spec [%s].", this.lookupName, lookupExtractorFactoryContainer);
                if (!lookupExtractorFactoryContainer.getLookupExtractorFactory().close()) {
                    throw new ISE("close method returned false for lookup [%s]:[%s]", this.lookupName, lookupExtractorFactoryContainer);
                }
            }
        }

        public String toString() {
            return "DropNotice{lookupName='" + this.lookupName + '\'' + '}';
        }
    }

    private static class LoadNotice
    implements Notice {
        private final String lookupName;
        private final LookupExtractorFactoryContainer lookupExtractorFactoryContainer;

        public LoadNotice(String lookupName, LookupExtractorFactoryContainer lookupExtractorFactoryContainer) {
            this.lookupName = lookupName;
            this.lookupExtractorFactoryContainer = lookupExtractorFactoryContainer;
        }

        @Override
        public void handle(Map<String, LookupExtractorFactoryContainer> lookupMap) {
            LookupExtractorFactoryContainer old = lookupMap.get(this.lookupName);
            if (old != null && !this.lookupExtractorFactoryContainer.replaces(old)) {
                LOG.warn("got notice to load lookup [%s] that can't replace existing [%s].", this.lookupExtractorFactoryContainer, old);
                return;
            }
            if (!this.lookupExtractorFactoryContainer.getLookupExtractorFactory().start()) {
                throw new ISE("start method returned false for lookup [%s]:[%s]", this.lookupName, this.lookupExtractorFactoryContainer);
            }
            old = lookupMap.put(this.lookupName, this.lookupExtractorFactoryContainer);
            LOG.debug("Loaded lookup [%s] with spec [%s].", this.lookupName, this.lookupExtractorFactoryContainer);
            if (old != null && !old.getLookupExtractorFactory().close()) {
                throw new ISE("close method returned false for lookup [%s]:[%s]", this.lookupName, old);
            }
        }

        public String toString() {
            return "LoadNotice{lookupName='" + this.lookupName + '\'' + ", lookupExtractorFactoryContainer=" + this.lookupExtractorFactoryContainer + '}';
        }
    }

    @VisibleForTesting
    static interface Notice {
        public void handle(Map<String, LookupExtractorFactoryContainer> var1);
    }
}

