/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.lookup;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.query.extraction.FunctionalExtraction;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;

public class LookupExtractionFn
extends FunctionalExtraction {
    private final LookupExtractor lookup;
    private final boolean optimize;
    private final boolean retainMissingValue;
    private final String replaceMissingValueWith;
    private final boolean injective;

    @JsonCreator
    public LookupExtractionFn(final @JsonProperty(value="lookup") LookupExtractor lookup, @JsonProperty(value="retainMissingValue") boolean retainMissingValue, @Nullable @JsonProperty(value="replaceMissingValueWith") String replaceMissingValueWith, @JsonProperty(value="injective") boolean injective, @JsonProperty(value="optimize") Boolean optimize) {
        super(new Function<String, String>(){

            @Override
            @Nullable
            public String apply(@Nullable String input) {
                return NullHandlingHelper.defaultToNull(lookup.apply(NullHandlingHelper.nullToDefault(input)));
            }
        }, retainMissingValue, replaceMissingValueWith, injective);
        this.lookup = lookup;
        this.optimize = optimize == null ? true : optimize;
        this.retainMissingValue = retainMissingValue;
        this.injective = injective;
        this.replaceMissingValueWith = replaceMissingValueWith;
    }

    @JsonProperty
    public LookupExtractor getLookup() {
        return this.lookup;
    }

    @Override
    @JsonProperty
    public boolean isRetainMissingValue() {
        return super.isRetainMissingValue();
    }

    @Override
    @JsonProperty
    public String getReplaceMissingValueWith() {
        return super.getReplaceMissingValueWith();
    }

    @Override
    @JsonProperty
    public boolean isInjective() {
        return super.isInjective();
    }

    @JsonProperty(value="optimize")
    public boolean isOptimize() {
        return this.optimize;
    }

    @Override
    public byte[] getCacheKey() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(7);
            outputStream.write(this.lookup.getCacheKey());
            if (this.getReplaceMissingValueWith() != null) {
                outputStream.write(StringUtils.toUtf8(this.getReplaceMissingValueWith()));
                outputStream.write(255);
            }
            outputStream.write(this.isInjective() ? 1 : 0);
            outputStream.write(this.isRetainMissingValue() ? 1 : 0);
            outputStream.write(this.isOptimize() ? 1 : 0);
            outputStream.write(this.getReplaceMissingValueWith() == null ? 1 : 0);
            return outputStream.toByteArray();
        }
        catch (IOException ex) {
            throw Throwables.propagate(ex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupExtractionFn that = (LookupExtractionFn)o;
        if (this.isOptimize() != that.isOptimize()) {
            return false;
        }
        if (this.isRetainMissingValue() != that.isRetainMissingValue()) {
            return false;
        }
        if (this.isInjective() != that.isInjective()) {
            return false;
        }
        if (this.getLookup() != null ? !this.getLookup().equals(that.getLookup()) : that.getLookup() != null) {
            return false;
        }
        return this.getReplaceMissingValueWith() != null ? this.getReplaceMissingValueWith().equals(that.getReplaceMissingValueWith()) : that.getReplaceMissingValueWith() == null;
    }

    public int hashCode() {
        int result = this.getLookup() != null ? this.getLookup().hashCode() : 0;
        result = 31 * result + (this.isOptimize() ? 1 : 0);
        result = 31 * result + (this.isRetainMissingValue() ? 1 : 0);
        result = 31 * result + (this.getReplaceMissingValueWith() != null ? this.getReplaceMissingValueWith().hashCode() : 0);
        result = 31 * result + (this.isInjective() ? 1 : 0);
        return result;
    }

    public String toString() {
        return "LookupExtractionFn{lookup=" + this.lookup + ", optimize=" + this.optimize + ", retainMissingValue=" + this.retainMissingValue + ", replaceMissingValueWith='" + this.replaceMissingValueWith + '\'' + ", injective=" + this.injective + '}';
    }
}

