/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.resource;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;

public class GroupByQueryResource
implements Closeable {
    private static final Logger log = new Logger(GroupByQueryResource.class);
    private final ResourceHolder<List<ByteBuffer>> mergeBuffersHolder;
    private final Deque<ByteBuffer> mergeBuffers;

    public GroupByQueryResource() {
        this.mergeBuffersHolder = null;
        this.mergeBuffers = new ArrayDeque<ByteBuffer>();
    }

    public GroupByQueryResource(ResourceHolder<List<ByteBuffer>> mergeBuffersHolder) {
        this.mergeBuffersHolder = mergeBuffersHolder;
        this.mergeBuffers = new ArrayDeque<ByteBuffer>((Collection)mergeBuffersHolder.get());
    }

    public ResourceHolder<ByteBuffer> getMergeBuffer() {
        final ByteBuffer buffer = this.mergeBuffers.pop();
        return new ResourceHolder<ByteBuffer>(){

            @Override
            public ByteBuffer get() {
                return buffer;
            }

            @Override
            public void close() {
                GroupByQueryResource.this.mergeBuffers.add(buffer);
            }
        };
    }

    @Override
    public void close() {
        if (this.mergeBuffersHolder != null) {
            if (this.mergeBuffers.size() != this.mergeBuffersHolder.get().size()) {
                log.warn("%d resources are not returned yet", this.mergeBuffersHolder.get().size() - this.mergeBuffers.size());
            }
            this.mergeBuffersHolder.close();
        }
    }
}

