/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.having;

import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.query.groupby.having.BaseHavingSpec;
import org.apache.hive.druid.io.druid.query.groupby.having.HavingSpec;
import org.apache.hive.druid.io.druid.segment.column.ValueType;

public class OrHavingSpec
extends BaseHavingSpec {
    private final List<HavingSpec> havingSpecs;

    @JsonCreator
    public OrHavingSpec(@JsonProperty(value="havingSpecs") List<HavingSpec> havingSpecs) {
        this.havingSpecs = havingSpecs == null ? ImmutableList.of() : havingSpecs;
    }

    @JsonProperty(value="havingSpecs")
    public List<HavingSpec> getHavingSpecs() {
        return this.havingSpecs;
    }

    @Override
    public void setRowSignature(Map<String, ValueType> rowSignature) {
        for (HavingSpec havingSpec : this.havingSpecs) {
            havingSpec.setRowSignature(rowSignature);
        }
    }

    @Override
    public boolean eval(Row row) {
        for (HavingSpec havingSpec : this.havingSpecs) {
            if (!havingSpec.eval(row)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrHavingSpec that = (OrHavingSpec)o;
        return !(this.havingSpecs != null ? !this.havingSpecs.equals(that.havingSpecs) : that.havingSpecs != null);
    }

    public int hashCode() {
        return this.havingSpecs != null ? this.havingSpecs.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OrHavingSpec");
        sb.append("{havingSpecs=").append(this.havingSpecs);
        sb.append('}');
        return sb.toString();
    }
}

