/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.having;

import java.util.regex.Pattern;
import org.apache.hive.druid.com.google.common.primitives.Floats;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.io.druid.data.input.Row;

class HavingSpecMetricComparator {
    static final Pattern LONG_PAT = Pattern.compile("[-|+]?\\d+");

    HavingSpecMetricComparator() {
    }

    static int compare(Row row, String aggregationName, Number value) {
        Object metricValueObj = row.getRaw(aggregationName);
        if (metricValueObj != null) {
            String metricValueStr;
            if (metricValueObj instanceof Long) {
                long l = (Long)metricValueObj;
                return Longs.compare(l, value.longValue());
            }
            if (metricValueObj instanceof String && LONG_PAT.matcher(metricValueStr = (String)metricValueObj).matches()) {
                long l = row.getLongMetric(aggregationName);
                return Longs.compare(l, value.longValue());
            }
        }
        float f = row.getFloatMetric(aggregationName).floatValue();
        return Floats.compare(f, value.floatValue());
    }
}

