/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae.column;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.column.StringGroupByColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;
import org.apache.hive.druid.io.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;

public class DictionaryBuildingStringGroupByColumnSelectorStrategy
extends StringGroupByColumnSelectorStrategy {
    private static final int GROUP_BY_MISSING_VALUE = -1;
    private int nextId = 0;
    private final List<String> dictionary = Lists.newArrayList();
    private final Object2IntOpenHashMap<String> reverseDictionary = new Object2IntOpenHashMap();

    public DictionaryBuildingStringGroupByColumnSelectorStrategy() {
        this.reverseDictionary.defaultReturnValue(-1);
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, Map<String, Object> resultMap) {
        int id = key.getInt(selectorPlus.getKeyBufferPosition());
        if (id != -1) {
            String value = this.dictionary.get(id);
            resultMap.put(selectorPlus.getOutputName(), value);
        } else {
            resultMap.put(selectorPlus.getOutputName(), NullHandlingHelper.nullToDefault((String)null));
        }
    }

    @Override
    public void initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] valuess) {
        DimensionSelector dimSelector = (DimensionSelector)selector;
        IndexedInts row = dimSelector.getRow();
        int[] newIds = new int[row.size()];
        for (int i = 0; i < row.size(); ++i) {
            String value = dimSelector.lookupName(row.get(i));
            int dictId = this.reverseDictionary.getInt(value);
            if (dictId < 0) {
                this.dictionary.add(value);
                this.reverseDictionary.put(value, this.nextId);
                newIds[i] = this.nextId++;
                continue;
            }
            newIds[i] = dictId;
        }
        valuess[columnIndex] = ArrayBasedIndexedInts.of(newIds);
    }

    @Override
    public Object getOnlyValue(ColumnValueSelector selector) {
        DimensionSelector dimSelector = (DimensionSelector)selector;
        IndexedInts row = dimSelector.getRow();
        Preconditions.checkState(row.size() < 2, "Not supported for multi-value dimensions");
        if (row.size() == 0) {
            return -1;
        }
        String value = dimSelector.lookupName(row.get(0));
        int dictId = this.reverseDictionary.getInt(value);
        if (dictId < 0) {
            this.dictionary.add(value);
            this.reverseDictionary.put(value, this.nextId);
            return this.nextId++;
        }
        return dictId;
    }
}

