/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.AbstractBufferHashGrouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.ByteBufferHashTable;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.ByteBufferMinMaxOffsetHeap;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;

public class LimitedBufferHashGrouper<KeyType>
extends AbstractBufferHashGrouper<KeyType> {
    private static final int MIN_INITIAL_BUCKETS = 4;
    private static final int DEFAULT_INITIAL_BUCKETS = 1024;
    private static final float DEFAULT_MAX_LOAD_FACTOR = 0.7f;
    private final AggregatorFactory[] aggregatorFactories;
    private int limit;
    private boolean sortHasNonGroupingFields;
    private ByteBufferMinMaxOffsetHeap offsetHeap;
    private ByteBuffer totalBuffer;
    private ByteBuffer hashTableBuffer;
    private ByteBuffer offsetHeapBuffer;
    private BufferGrouperOffsetHeapIndexUpdater heapIndexUpdater;
    private boolean initialized = false;

    public LimitedBufferHashGrouper(Supplier<ByteBuffer> bufferSupplier, Grouper.KeySerde<KeyType> keySerde, ColumnSelectorFactory columnSelectorFactory, AggregatorFactory[] aggregatorFactories, int bufferGrouperMaxSize, float maxLoadFactor, int initialBuckets, int limit, boolean sortHasNonGroupingFields) {
        super(bufferSupplier, keySerde, aggregatorFactories, bufferGrouperMaxSize);
        this.maxLoadFactor = maxLoadFactor > 0.0f ? maxLoadFactor : 0.7f;
        this.initialBuckets = initialBuckets > 0 ? Math.max(4, initialBuckets) : 1024;
        this.limit = limit;
        this.sortHasNonGroupingFields = sortHasNonGroupingFields;
        if (this.maxLoadFactor >= 1.0f) {
            throw new IAE("Invalid maxLoadFactor[%f], must be < 1.0", Float.valueOf(maxLoadFactor));
        }
        int offset = 4 + this.keySize;
        this.aggregatorFactories = aggregatorFactories;
        for (int i = 0; i < aggregatorFactories.length; ++i) {
            this.aggregators[i] = aggregatorFactories[i].factorizeBuffered(columnSelectorFactory);
            this.aggregatorOffsets[i] = offset;
            offset += aggregatorFactories[i].getMaxIntermediateSize();
        }
        this.bucketSize = offset += 4;
    }

    @Override
    public void init() {
        if (this.initialized) {
            return;
        }
        this.totalBuffer = (ByteBuffer)this.bufferSupplier.get();
        this.validateBufferCapacity(this.limit, this.maxLoadFactor, this.totalBuffer, this.bucketSize);
        int heapByteSize = (this.limit + 1) * 4;
        int hashTableSize = ByteBufferHashTable.calculateTableArenaSizeWithFixedAdditionalSize(this.totalBuffer.capacity(), this.bucketSize, heapByteSize);
        this.hashTableBuffer = this.totalBuffer.duplicate();
        this.hashTableBuffer.position(0);
        this.hashTableBuffer.limit(hashTableSize);
        this.hashTableBuffer = this.hashTableBuffer.slice();
        this.offsetHeapBuffer = this.totalBuffer.duplicate();
        this.offsetHeapBuffer.position(hashTableSize);
        this.offsetHeapBuffer = this.offsetHeapBuffer.slice();
        this.offsetHeapBuffer.limit(this.totalBuffer.capacity() - hashTableSize);
        this.hashTable = new AlternatingByteBufferHashTable(this.maxLoadFactor, this.initialBuckets, this.bucketSize, this.hashTableBuffer, this.keySize, this.bufferGrouperMaxSize);
        this.heapIndexUpdater = new BufferGrouperOffsetHeapIndexUpdater(this.totalBuffer, this.bucketSize - 4);
        this.offsetHeap = new ByteBufferMinMaxOffsetHeap(this.offsetHeapBuffer, this.limit, this.makeHeapComparator(), this.heapIndexUpdater);
        this.reset();
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void newBucketHook(int bucketOffset) {
        this.heapIndexUpdater.updateHeapIndexForOffset(bucketOffset, -1);
    }

    @Override
    public boolean canSkipAggregate(boolean bucketWasUsed, int bucketOffset) {
        return bucketWasUsed && !this.sortHasNonGroupingFields && this.heapIndexUpdater.getHeapIndexForOffset(bucketOffset) < 0;
    }

    @Override
    public void afterAggregateHook(int bucketOffset) {
        int heapIndex = this.heapIndexUpdater.getHeapIndexForOffset(bucketOffset);
        if (heapIndex < 0) {
            this.offsetHeap.addOffset(bucketOffset);
        } else if (this.sortHasNonGroupingFields) {
            this.offsetHeap.removeAt(heapIndex);
            this.offsetHeap.addOffset(bucketOffset);
        }
    }

    @Override
    public void reset() {
        this.hashTable.reset();
        this.keySerde.reset();
        this.offsetHeap.reset();
        this.heapIndexUpdater.setHashTableBuffer(this.hashTable.getTableBuffer());
    }

    @Override
    public Iterator<Grouper.Entry<KeyType>> iterator(boolean sorted) {
        if (!this.initialized) {
            return Iterators.emptyIterator();
        }
        if (this.sortHasNonGroupingFields) {
            return this.makeDefaultOrderingIterator();
        }
        return this.makeHeapIterator();
    }

    public int getLimit() {
        return this.limit;
    }

    private Iterator<Grouper.Entry<KeyType>> makeDefaultOrderingIterator() {
        final int size = this.offsetHeap.getHeapSize();
        final AbstractList<Integer> wrappedOffsets = new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return LimitedBufferHashGrouper.this.offsetHeap.getAt(index);
            }

            @Override
            public Integer set(int index, Integer element) {
                Integer oldValue = this.get(index);
                LimitedBufferHashGrouper.this.offsetHeap.setAt(index, element);
                return oldValue;
            }

            @Override
            public int size() {
                return size;
            }
        };
        final Grouper.BufferComparator comparator = this.keySerde.bufferComparator();
        Collections.sort(wrappedOffsets, new Comparator<Integer>(){

            @Override
            public int compare(Integer lhs, Integer rhs) {
                ByteBuffer curHashTableBuffer = LimitedBufferHashGrouper.this.hashTable.getTableBuffer();
                return comparator.compare(curHashTableBuffer, curHashTableBuffer, lhs + 4, rhs + 4);
            }
        });
        return new Iterator<Grouper.Entry<KeyType>>(){
            int curr = 0;

            @Override
            public boolean hasNext() {
                return this.curr < size;
            }

            @Override
            public Grouper.Entry<KeyType> next() {
                return LimitedBufferHashGrouper.this.bucketEntryForOffset((Integer)wrappedOffsets.get(this.curr++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Iterator<Grouper.Entry<KeyType>> makeHeapIterator() {
        final int initialHeapSize = this.offsetHeap.getHeapSize();
        return new Iterator<Grouper.Entry<KeyType>>(){
            int curr = 0;

            @Override
            public boolean hasNext() {
                return this.curr < initialHeapSize;
            }

            @Override
            public Grouper.Entry<KeyType> next() {
                if (this.curr >= initialHeapSize) {
                    throw new NoSuchElementException();
                }
                int offset = LimitedBufferHashGrouper.this.offsetHeap.removeMin();
                Grouper.Entry entry = LimitedBufferHashGrouper.this.bucketEntryForOffset(offset);
                ++this.curr;
                return entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Comparator<Integer> makeHeapComparator() {
        return new Comparator<Integer>(){
            final Grouper.BufferComparator bufferComparator;
            {
                this.bufferComparator = LimitedBufferHashGrouper.this.keySerde.bufferComparatorWithAggregators(LimitedBufferHashGrouper.this.aggregatorFactories, LimitedBufferHashGrouper.this.aggregatorOffsets);
            }

            @Override
            public int compare(Integer o1, Integer o2) {
                ByteBuffer tableBuffer = LimitedBufferHashGrouper.this.hashTable.getTableBuffer();
                return this.bufferComparator.compare(tableBuffer, tableBuffer, o1 + 4, o2 + 4);
            }
        };
    }

    private void validateBufferCapacity(int limit, float maxLoadFactor, ByteBuffer buffer, int bucketSize) {
        int numBucketsNeeded = (int)Math.ceil((float)(limit + 1) / maxLoadFactor);
        int targetTableArenaSize = numBucketsNeeded * bucketSize * 2;
        int heapSize = (limit + 1) * 4;
        int requiredSize = targetTableArenaSize + heapSize;
        if (buffer.capacity() < requiredSize) {
            throw new IAE("Buffer capacity [%d] is too small for limit[%d] with load factor[%f], minimum bytes needed: [%d]", buffer.capacity(), limit, Float.valueOf(maxLoadFactor), requiredSize);
        }
    }

    private class AlternatingByteBufferHashTable
    extends ByteBufferHashTable {
        private ByteBuffer[] subHashTableBuffers;

        public AlternatingByteBufferHashTable(float maxLoadFactor, int initialBuckets, int bucketSizeWithHash, ByteBuffer totalHashTableBuffer, int keySize, int maxSizeForTesting) {
            super(maxLoadFactor, initialBuckets, bucketSizeWithHash, totalHashTableBuffer, keySize, maxSizeForTesting, null);
            this.growthCount = 0;
            int subHashTableSize = this.tableArenaSize / 2;
            this.maxBuckets = subHashTableSize / bucketSizeWithHash;
            this.regrowthThreshold = this.maxSizeForBuckets(this.maxBuckets);
            ByteBuffer subHashTable1Buffer = totalHashTableBuffer.duplicate();
            subHashTable1Buffer.position(0);
            subHashTable1Buffer.limit(subHashTableSize);
            subHashTable1Buffer = subHashTable1Buffer.slice();
            ByteBuffer subHashTable2Buffer = totalHashTableBuffer.duplicate();
            subHashTable2Buffer.position(subHashTableSize);
            subHashTable2Buffer.limit(this.tableArenaSize);
            subHashTable2Buffer = subHashTable2Buffer.slice();
            this.subHashTableBuffers = new ByteBuffer[]{subHashTable1Buffer, subHashTable2Buffer};
        }

        @Override
        public void reset() {
            this.size = 0;
            this.growthCount = 0;
            for (int i = 0; i < this.maxBuckets; ++i) {
                this.subHashTableBuffers[0].put(i * this.bucketSizeWithHash, (byte)0);
            }
            this.tableBuffer = this.subHashTableBuffers[0];
        }

        @Override
        public void adjustTableWhenFull() {
            int newTableIdx = this.growthCount % 2 == 0 ? 1 : 0;
            ByteBuffer newTableBuffer = this.subHashTableBuffers[newTableIdx];
            for (int i = 0; i < this.maxBuckets; ++i) {
                newTableBuffer.put(i * this.bucketSizeWithHash, (byte)0);
            }
            ByteBuffer entryBuffer = this.tableBuffer.duplicate();
            ByteBuffer keyBuffer = this.tableBuffer.duplicate();
            int numCopied = 0;
            for (int i = 0; i < LimitedBufferHashGrouper.this.offsetHeap.getHeapSize(); ++i) {
                int oldBucketOffset = LimitedBufferHashGrouper.this.offsetHeap.getAt(i);
                if (!this.isOffsetUsed(oldBucketOffset)) continue;
                entryBuffer.limit(oldBucketOffset + this.bucketSizeWithHash);
                entryBuffer.position(oldBucketOffset);
                keyBuffer.limit(entryBuffer.position() + 4 + this.keySize);
                keyBuffer.position(entryBuffer.position() + 4);
                int keyHash = entryBuffer.getInt(entryBuffer.position()) & Integer.MAX_VALUE;
                int newBucket = this.findBucket(true, this.maxBuckets, newTableBuffer, keyBuffer, keyHash);
                if (newBucket < 0) {
                    throw new ISE("WTF?! Couldn't find a bucket while resizing?!", new Object[0]);
                }
                int newBucketOffset = newBucket * this.bucketSizeWithHash;
                newTableBuffer.position(newBucketOffset);
                newTableBuffer.put(entryBuffer);
                ++numCopied;
                LimitedBufferHashGrouper.this.offsetHeap.setAt(i, newBucketOffset);
                for (int j = 0; j < LimitedBufferHashGrouper.this.aggregators.length; ++j) {
                    LimitedBufferHashGrouper.this.aggregators[j].relocate(oldBucketOffset + LimitedBufferHashGrouper.this.aggregatorOffsets[j], newBucketOffset + LimitedBufferHashGrouper.this.aggregatorOffsets[j], this.tableBuffer, newTableBuffer);
                }
            }
            this.size = numCopied;
            this.tableBuffer = newTableBuffer;
            ++this.growthCount;
        }
    }

    public static class BufferGrouperOffsetHeapIndexUpdater {
        private ByteBuffer hashTableBuffer;
        private final int indexPosition;

        public BufferGrouperOffsetHeapIndexUpdater(ByteBuffer hashTableBuffer, int indexPosition) {
            this.hashTableBuffer = hashTableBuffer;
            this.indexPosition = indexPosition;
        }

        public void setHashTableBuffer(ByteBuffer newTableBuffer) {
            this.hashTableBuffer = newTableBuffer;
        }

        public void updateHeapIndexForOffset(int bucketOffset, int newHeapIndex) {
            this.hashTableBuffer.putInt(bucketOffset + this.indexPosition, newHeapIndex);
        }

        public int getHeapIndexForOffset(int bucketOffset) {
            return this.hashTableBuffer.getInt(bucketOffset + this.indexPosition);
        }
    }
}

