/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.common.guava.SettableSupplier;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.guava.Accumulator;
import org.apache.hive.druid.io.druid.java.util.common.guava.BaseSequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.java.util.common.guava.FilteredSequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.ResourceLimitExceededException;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.RowBasedColumnSelectorFactory;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.RowBasedGrouperHelper;
import org.apache.hive.druid.io.druid.query.groupby.resource.GroupByQueryResource;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.filter.BooleanValueMatcher;
import org.apache.hive.druid.io.druid.segment.filter.Filters;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class GroupByRowProcessor {
    public static Sequence<Row> process(Query queryParam, Sequence<Row> rows, final Map<String, ValueType> rowSignature, GroupByQueryConfig config, final GroupByQueryResource resource, final ObjectMapper spillMapper, String processingTmpDir) {
        final GroupByQuery query = (GroupByQuery)queryParam;
        final GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
        final AggregatorFactory[] aggregatorFactories = new AggregatorFactory[query.getAggregatorSpecs().size()];
        for (int i = 0; i < query.getAggregatorSpecs().size(); ++i) {
            aggregatorFactories[i] = query.getAggregatorSpecs().get(i);
        }
        final File temporaryStorageDirectory = new File(processingTmpDir, StringUtils.format("druid-groupBy-%s_%s", UUID.randomUUID(), query.getId()));
        final List<Interval> queryIntervals = query.getIntervals();
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimFilter()));
        final SettableSupplier rowSupplier = new SettableSupplier();
        RowBasedColumnSelectorFactory columnSelectorFactory = RowBasedColumnSelectorFactory.create(rowSupplier, rowSignature);
        final ValueMatcher filterMatcher = filter == null ? BooleanValueMatcher.of(true) : filter.makeMatcher(columnSelectorFactory);
        final FilteredSequence<Row> filteredSequence = new FilteredSequence<Row>(rows, new Predicate<Row>(){

            @Override
            public boolean apply(Row input) {
                boolean inInterval = false;
                DateTime rowTime = input.getTimestamp();
                for (Interval queryInterval : queryIntervals) {
                    if (!queryInterval.contains((ReadableInstant)rowTime)) continue;
                    inInterval = true;
                    break;
                }
                if (!inInterval) {
                    return false;
                }
                rowSupplier.set(input);
                return filterMatcher.matches();
            }
        });
        return new BaseSequence<Row, CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row>>(new BaseSequence.IteratorMaker<Row, CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row>>(){

            @Override
            public CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row> make() {
                final ArrayList<Closeable> closeOnExit = Lists.newArrayList();
                try {
                    LimitedTemporaryStorage temporaryStorage = new LimitedTemporaryStorage(temporaryStorageDirectory, querySpecificConfig.getMaxOnDiskStorage());
                    closeOnExit.add(temporaryStorage);
                    Pair<Grouper<RowBasedGrouperHelper.RowBasedKey>, Accumulator<AggregateResult, Row>> pair = RowBasedGrouperHelper.createGrouperAccumulatorPair(query, true, rowSignature, querySpecificConfig, new Supplier<ByteBuffer>(){

                        @Override
                        public ByteBuffer get() {
                            ResourceHolder<ByteBuffer> mergeBufferHolder = resource.getMergeBuffer();
                            closeOnExit.add(mergeBufferHolder);
                            return mergeBufferHolder.get();
                        }
                    }, -1, temporaryStorage, spillMapper, aggregatorFactories);
                    Grouper grouper = (Grouper)pair.lhs;
                    Accumulator accumulator = (Accumulator)pair.rhs;
                    closeOnExit.add(grouper);
                    AggregateResult retVal = filteredSequence.accumulate(AggregateResult.ok(), accumulator);
                    if (!retVal.isOk()) {
                        throw new ResourceLimitExceededException(retVal.getReason(), new Object[0]);
                    }
                    return RowBasedGrouperHelper.makeGrouperIterator(grouper, query, new Closeable(){

                        @Override
                        public void close() throws IOException {
                            for (Closeable closeable : Lists.reverse(closeOnExit)) {
                                CloseQuietly.close(closeable);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    for (Closeable closeable : Lists.reverse(closeOnExit)) {
                        CloseQuietly.close(closeable);
                    }
                    throw e;
                }
            }

            @Override
            public void cleanup(CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row> iterFromMake) {
                iterFromMake.close();
            }
        });
    }
}

