/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.collections.BlockingPool;
import org.apache.hive.druid.io.druid.collections.ReferenceCountingResourceHolder;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.guava.Accumulator;
import org.apache.hive.druid.io.druid.java.util.common.guava.BaseSequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.AbstractPrioritizedCallable;
import org.apache.hive.druid.io.druid.query.ChainedExecutionQueryRunner;
import org.apache.hive.druid.io.druid.query.QueryContexts;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryWatcher;
import org.apache.hive.druid.io.druid.query.ResourceLimitExceededException;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.RowBasedGrouperHelper;

public class GroupByMergingQueryRunnerV2
implements QueryRunner<Row> {
    private static final Logger log = new Logger(GroupByMergingQueryRunnerV2.class);
    private static final String CTX_KEY_MERGE_RUNNERS_USING_CHAINED_EXECUTION = "mergeRunnersUsingChainedExecution";
    private final GroupByQueryConfig config;
    private final Iterable<QueryRunner<Row>> queryables;
    private final ListeningExecutorService exec;
    private final QueryWatcher queryWatcher;
    private final int concurrencyHint;
    private final BlockingPool<ByteBuffer> mergeBufferPool;
    private final ObjectMapper spillMapper;
    private final String processingTmpDir;

    public GroupByMergingQueryRunnerV2(GroupByQueryConfig config, ExecutorService exec, QueryWatcher queryWatcher, Iterable<QueryRunner<Row>> queryables, int concurrencyHint, BlockingPool<ByteBuffer> mergeBufferPool, ObjectMapper spillMapper, String processingTmpDir) {
        this.config = config;
        this.exec = MoreExecutors.listeningDecorator(exec);
        this.queryWatcher = queryWatcher;
        this.queryables = Iterables.unmodifiableIterable(Iterables.filter(queryables, Predicates.notNull()));
        this.concurrencyHint = concurrencyHint;
        this.mergeBufferPool = mergeBufferPool;
        this.spillMapper = spillMapper;
        this.processingTmpDir = processingTmpDir;
    }

    @Override
    public Sequence<Row> run(QueryPlus<Row> queryPlus, final Map<String, Object> responseContext) {
        final GroupByQuery query = (GroupByQuery)queryPlus.getQuery();
        final GroupByQueryConfig querySpecificConfig = this.config.withOverrides(query);
        boolean forceChainedExecution = query.getContextBoolean(CTX_KEY_MERGE_RUNNERS_USING_CHAINED_EXECUTION, false);
        final QueryPlus queryPlusForRunners = queryPlus.withQuery(query.withOverriddenContext(ImmutableMap.of(CTX_KEY_MERGE_RUNNERS_USING_CHAINED_EXECUTION, true))).withoutThreadUnsafeState();
        if (QueryContexts.isBySegment(query) || forceChainedExecution) {
            ChainedExecutionQueryRunner runner = new ChainedExecutionQueryRunner((ExecutorService)this.exec, this.queryWatcher, this.queryables);
            return runner.run(queryPlusForRunners, responseContext);
        }
        final boolean isSingleThreaded = querySpecificConfig.isSingleThreaded();
        final AggregatorFactory[] combiningAggregatorFactories = new AggregatorFactory[query.getAggregatorSpecs().size()];
        for (int i = 0; i < query.getAggregatorSpecs().size(); ++i) {
            combiningAggregatorFactories[i] = query.getAggregatorSpecs().get(i).getCombiningFactory();
        }
        final File temporaryStorageDirectory = new File(this.processingTmpDir, StringUtils.format("druid-groupBy-%s_%s", UUID.randomUUID(), query.getId()));
        final int priority = QueryContexts.getPriority(query);
        long queryTimeout = QueryContexts.getTimeout(query);
        final boolean hasTimeout = QueryContexts.hasTimeout(query);
        final long timeoutAt = System.currentTimeMillis() + queryTimeout;
        return new BaseSequence<Row, CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row>>(new BaseSequence.IteratorMaker<Row, CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row>>(){

            @Override
            public CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row> make() {
                final ArrayList resources = Lists.newArrayList();
                try {
                    ReferenceCountingResourceHolder mergeBufferHolder;
                    LimitedTemporaryStorage temporaryStorage = new LimitedTemporaryStorage(temporaryStorageDirectory, querySpecificConfig.getMaxOnDiskStorage());
                    ReferenceCountingResourceHolder<LimitedTemporaryStorage> temporaryStorageHolder = ReferenceCountingResourceHolder.fromCloseable(temporaryStorage);
                    resources.add(temporaryStorageHolder);
                    try {
                        if (hasTimeout) {
                            long timeout = timeoutAt - System.currentTimeMillis();
                            if (timeout <= 0L || (mergeBufferHolder = GroupByMergingQueryRunnerV2.this.mergeBufferPool.take(timeout)) == null) {
                                throw new TimeoutException();
                            }
                        } else {
                            mergeBufferHolder = GroupByMergingQueryRunnerV2.this.mergeBufferPool.take();
                        }
                        resources.add(mergeBufferHolder);
                    }
                    catch (Exception e) {
                        throw new QueryInterruptedException(e);
                    }
                    Pair<Grouper<RowBasedGrouperHelper.RowBasedKey>, Accumulator<AggregateResult, Row>> pair = RowBasedGrouperHelper.createGrouperAccumulatorPair(query, false, null, GroupByMergingQueryRunnerV2.this.config, Suppliers.ofInstance(mergeBufferHolder.get()), GroupByMergingQueryRunnerV2.this.concurrencyHint, temporaryStorage, GroupByMergingQueryRunnerV2.this.spillMapper, combiningAggregatorFactories);
                    Grouper grouper = (Grouper)pair.lhs;
                    final Accumulator accumulator = (Accumulator)pair.rhs;
                    grouper.init();
                    final ReferenceCountingResourceHolder<Grouper> grouperHolder = ReferenceCountingResourceHolder.fromCloseable(grouper);
                    resources.add(grouperHolder);
                    ListenableFuture<List<AggregateResult>> futures = Futures.allAsList(Lists.newArrayList(Iterables.transform(GroupByMergingQueryRunnerV2.this.queryables, new Function<QueryRunner<Row>, ListenableFuture<AggregateResult>>(){

                        @Override
                        public ListenableFuture<AggregateResult> apply(final QueryRunner<Row> input) {
                            if (input == null) {
                                throw new ISE("Null queryRunner! Looks to be some segment unmapping action happening", new Object[0]);
                            }
                            ListenableFuture<AggregateResult> future = GroupByMergingQueryRunnerV2.this.exec.submit(new AbstractPrioritizedCallable<AggregateResult>(priority){

                                /*
                                 * Exception decompiling
                                 */
                                @Override
                                public AggregateResult call() throws Exception {
                                    /*
                                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                     * 
                                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                     */
                                    throw new IllegalStateException("Decompilation failed");
                                }
                            });
                            if (isSingleThreaded) {
                                GroupByMergingQueryRunnerV2.this.waitForFutureCompletion(query, Futures.allAsList(ImmutableList.of(future)), hasTimeout, timeoutAt - System.currentTimeMillis());
                            }
                            return future;
                        }
                    })));
                    if (!isSingleThreaded) {
                        GroupByMergingQueryRunnerV2.this.waitForFutureCompletion(query, futures, hasTimeout, timeoutAt - System.currentTimeMillis());
                    }
                    return RowBasedGrouperHelper.makeGrouperIterator(grouper, query, new Closeable(){

                        @Override
                        public void close() throws IOException {
                            for (Closeable closeable : Lists.reverse(resources)) {
                                CloseQuietly.close(closeable);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    for (Closeable closeable : Lists.reverse(resources)) {
                        CloseQuietly.close(closeable);
                    }
                    throw e;
                }
            }

            @Override
            public void cleanup(CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row> iterFromMake) {
                iterFromMake.close();
            }
        });
    }

    private void waitForFutureCompletion(GroupByQuery query, ListenableFuture<List<AggregateResult>> future, boolean hasTimeout, long timeout) {
        try {
            if (this.queryWatcher != null) {
                this.queryWatcher.registerQuery(query, future);
            }
            if (hasTimeout && timeout <= 0L) {
                throw new TimeoutException();
            }
            List results = hasTimeout ? (List)future.get(timeout, TimeUnit.MILLISECONDS) : (List)future.get();
            for (AggregateResult result : results) {
                if (result.isOk()) continue;
                future.cancel(true);
                throw new ResourceLimitExceededException(result.getReason(), new Object[0]);
            }
        }
        catch (InterruptedException e) {
            log.warn(e, "Query interrupted, cancelling pending results, query id [%s]", query.getId());
            future.cancel(true);
            throw new QueryInterruptedException(e);
        }
        catch (CancellationException e) {
            throw new QueryInterruptedException(e);
        }
        catch (TimeoutException e) {
            log.info("Query timeout, cancelling pending results for query id [%s]", query.getId());
            future.cancel(true);
            throw new QueryInterruptedException(e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    static /* synthetic */ Logger access$500() {
        return log;
    }
}

