/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby;

import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;

public class GroupByQueryConfig {
    public static final String CTX_KEY_STRATEGY = "groupByStrategy";
    public static final String CTX_KEY_FORCE_LIMIT_PUSH_DOWN = "forceLimitPushDown";
    public static final String CTX_KEY_APPLY_LIMIT_PUSH_DOWN = "applyLimitPushDown";
    private static final String CTX_KEY_IS_SINGLE_THREADED = "groupByIsSingleThreaded";
    private static final String CTX_KEY_MAX_INTERMEDIATE_ROWS = "maxIntermediateRows";
    private static final String CTX_KEY_MAX_RESULTS = "maxResults";
    private static final String CTX_KEY_BUFFER_GROUPER_INITIAL_BUCKETS = "bufferGrouperInitialBuckets";
    private static final String CTX_KEY_BUFFER_GROUPER_MAX_LOAD_FACTOR = "bufferGrouperMaxLoadFactor";
    private static final String CTX_KEY_BUFFER_GROUPER_MAX_SIZE = "bufferGrouperMaxSize";
    private static final String CTX_KEY_MAX_ON_DISK_STORAGE = "maxOnDiskStorage";
    private static final String CTX_KEY_MAX_MERGING_DICTIONARY_SIZE = "maxMergingDictionarySize";
    private static final String CTX_KEY_FORCE_HASH_AGGREGATION = "forceHashAggregation";
    @JsonProperty
    private String defaultStrategy = "v2";
    @JsonProperty
    private boolean singleThreaded = false;
    @JsonProperty
    private int maxIntermediateRows = 50000;
    @JsonProperty
    private int maxResults = 500000;
    @JsonProperty
    private int bufferGrouperMaxSize = Integer.MAX_VALUE;
    @JsonProperty
    private float bufferGrouperMaxLoadFactor = 0.0f;
    @JsonProperty
    private int bufferGrouperInitialBuckets = 0;
    @JsonProperty
    private long maxMergingDictionarySize = 100000000L;
    @JsonProperty
    private long maxOnDiskStorage = 0L;
    @JsonProperty
    private boolean forcePushDownLimit = false;
    @JsonProperty
    private boolean forceHashAggregation = false;

    public String getDefaultStrategy() {
        return this.defaultStrategy;
    }

    public boolean isSingleThreaded() {
        return this.singleThreaded;
    }

    public void setSingleThreaded(boolean singleThreaded) {
        this.singleThreaded = singleThreaded;
    }

    public int getMaxIntermediateRows() {
        return this.maxIntermediateRows;
    }

    public void setMaxIntermediateRows(int maxIntermediateRows) {
        this.maxIntermediateRows = maxIntermediateRows;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getBufferGrouperMaxSize() {
        return this.bufferGrouperMaxSize;
    }

    public float getBufferGrouperMaxLoadFactor() {
        return this.bufferGrouperMaxLoadFactor;
    }

    public int getBufferGrouperInitialBuckets() {
        return this.bufferGrouperInitialBuckets;
    }

    public long getMaxMergingDictionarySize() {
        return this.maxMergingDictionarySize;
    }

    public long getMaxOnDiskStorage() {
        return this.maxOnDiskStorage;
    }

    public boolean isForcePushDownLimit() {
        return this.forcePushDownLimit;
    }

    public boolean isForceHashAggregation() {
        return this.forceHashAggregation;
    }

    public GroupByQueryConfig withOverrides(GroupByQuery query) {
        GroupByQueryConfig newConfig = new GroupByQueryConfig();
        newConfig.defaultStrategy = query.getContextValue(CTX_KEY_STRATEGY, this.getDefaultStrategy());
        newConfig.singleThreaded = query.getContextBoolean(CTX_KEY_IS_SINGLE_THREADED, this.isSingleThreaded());
        newConfig.maxIntermediateRows = Math.min(query.getContextValue(CTX_KEY_MAX_INTERMEDIATE_ROWS, this.getMaxIntermediateRows()), this.getMaxIntermediateRows());
        newConfig.maxResults = Math.min(query.getContextValue(CTX_KEY_MAX_RESULTS, this.getMaxResults()), this.getMaxResults());
        newConfig.bufferGrouperMaxSize = Math.min(query.getContextValue(CTX_KEY_BUFFER_GROUPER_MAX_SIZE, this.getBufferGrouperMaxSize()), this.getBufferGrouperMaxSize());
        newConfig.bufferGrouperMaxLoadFactor = query.getContextValue(CTX_KEY_BUFFER_GROUPER_MAX_LOAD_FACTOR, Float.valueOf(this.getBufferGrouperMaxLoadFactor())).floatValue();
        newConfig.bufferGrouperInitialBuckets = query.getContextValue(CTX_KEY_BUFFER_GROUPER_INITIAL_BUCKETS, this.getBufferGrouperInitialBuckets());
        newConfig.maxOnDiskStorage = Math.min(((Number)query.getContextValue(CTX_KEY_MAX_ON_DISK_STORAGE, this.getMaxOnDiskStorage())).longValue(), this.getMaxOnDiskStorage());
        newConfig.maxMergingDictionarySize = Math.min(((Number)query.getContextValue(CTX_KEY_MAX_MERGING_DICTIONARY_SIZE, this.getMaxMergingDictionarySize())).longValue(), this.getMaxMergingDictionarySize());
        newConfig.forcePushDownLimit = query.getContextBoolean(CTX_KEY_FORCE_LIMIT_PUSH_DOWN, this.isForcePushDownLimit());
        newConfig.forceHashAggregation = query.getContextBoolean(CTX_KEY_FORCE_HASH_AGGREGATION, this.isForceHashAggregation());
        return newConfig;
    }

    public String toString() {
        return "GroupByQueryConfig{defaultStrategy='" + this.defaultStrategy + '\'' + ", singleThreaded=" + this.singleThreaded + ", maxIntermediateRows=" + this.maxIntermediateRows + ", maxResults=" + this.maxResults + ", bufferGrouperMaxSize=" + this.bufferGrouperMaxSize + ", bufferGrouperMaxLoadFactor=" + this.bufferGrouperMaxLoadFactor + ", bufferGrouperInitialBuckets=" + this.bufferGrouperInitialBuckets + ", maxMergingDictionarySize=" + this.maxMergingDictionarySize + ", maxOnDiskStorage=" + this.maxOnDiskStorage + ", forcePushDownLimit=" + this.forcePushDownLimit + ", forceHashAggregation=" + this.forceHashAggregation + '}';
    }
}

