/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.filter;

import org.apache.hive.druid.io.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.io.druid.query.filter.ValueGetter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;

public class LongValueMatcherColumnSelectorStrategy
implements ValueMatcherColumnSelectorStrategy<LongColumnSelector> {
    @Override
    public ValueMatcher makeValueMatcher(final LongColumnSelector selector, String value) {
        Long matchVal = DimensionHandlerUtils.convertObjectToLong(value);
        if (matchVal == null) {
            return new ValueMatcher(){

                @Override
                public boolean matches() {
                    return selector.isNull();
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("selector", selector);
                }
            };
        }
        final long matchValLong = matchVal;
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return selector.getLong() == matchValLong;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final LongColumnSelector selector, DruidPredicateFactory predicateFactory) {
        final DruidLongPredicate predicate = predicateFactory.makeLongPredicate();
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                if (selector.isNull()) {
                    return predicate.applyNull();
                }
                return predicate.applyLong(selector.getLong());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    @Override
    public ValueGetter makeValueGetter(LongColumnSelector selector) {
        return () -> {
            if (selector.isNull()) {
                return null;
            }
            return new String[]{Long.toString(selector.getLong())};
        };
    }
}

