/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.filter;

import org.apache.hive.druid.io.druid.query.filter.DruidFloatPredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.io.druid.query.filter.ValueGetter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;

public class FloatValueMatcherColumnSelectorStrategy
implements ValueMatcherColumnSelectorStrategy<FloatColumnSelector> {
    @Override
    public ValueMatcher makeValueMatcher(final FloatColumnSelector selector, String value) {
        Float matchVal = DimensionHandlerUtils.convertObjectToFloat(value);
        if (matchVal == null) {
            return new ValueMatcher(){

                @Override
                public boolean matches() {
                    return selector.isNull();
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("selector", selector);
                }
            };
        }
        final int matchValIntBits = Float.floatToIntBits(matchVal.floatValue());
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return Float.floatToIntBits(selector.getFloat()) == matchValIntBits;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final FloatColumnSelector selector, DruidPredicateFactory predicateFactory) {
        final DruidFloatPredicate predicate = predicateFactory.makeFloatPredicate();
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                if (selector.isNull()) {
                    return predicate.applyNull();
                }
                return predicate.applyFloat(selector.getFloat());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    @Override
    public ValueGetter makeValueGetter(FloatColumnSelector selector) {
        return () -> {
            if (selector.isNull()) {
                return null;
            }
            return new String[]{Float.toString(selector.getFloat())};
        };
    }
}

