/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprEval;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.query.expression.ExprUtils;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public class TimestampExtractExprMacro
implements ExprMacroTable.ExprMacro {
    @Override
    public String name() {
        return "timestamp_extract";
    }

    @Override
    public Expr apply(List<Expr> args) {
        if (args.size() < 2 || args.size() > 3) {
            throw new IAE("Function[%s] must have 2 to 3 arguments", this.name());
        }
        if (!args.get(1).isLiteral() || args.get(1).getLiteralValue() == null) {
            throw new IAE("Function[%s] unit arg must be literal", this.name());
        }
        if (args.size() > 2 && !args.get(2).isLiteral()) {
            throw new IAE("Function[%s] timezone arg must be literal", this.name());
        }
        final Expr arg = args.get(0);
        final Unit unit = Unit.valueOf(((String)args.get(1).getLiteralValue()).toUpperCase());
        DateTimeZone timeZone = args.size() > 2 ? ExprUtils.toTimeZone(args.get(2)) : DateTimeZone.UTC;
        final ISOChronology chronology = ISOChronology.getInstance((DateTimeZone)timeZone);
        class TimestampExtractExpr
        implements Expr {
            TimestampExtractExpr() {
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                DateTime dateTime = new DateTime(arg.eval(bindings).asLong()).withChronology((Chronology)chronology);
                switch (unit) {
                    case EPOCH: {
                        return ExprEval.of(dateTime.getMillis());
                    }
                    case SECOND: {
                        return ExprEval.of(dateTime.secondOfMinute().get());
                    }
                    case MINUTE: {
                        return ExprEval.of(dateTime.minuteOfHour().get());
                    }
                    case HOUR: {
                        return ExprEval.of(dateTime.hourOfDay().get());
                    }
                    case DAY: {
                        return ExprEval.of(dateTime.dayOfMonth().get());
                    }
                    case DOW: {
                        return ExprEval.of(dateTime.dayOfWeek().get());
                    }
                    case DOY: {
                        return ExprEval.of(dateTime.dayOfYear().get());
                    }
                    case WEEK: {
                        return ExprEval.of(dateTime.weekOfWeekyear().get());
                    }
                    case MONTH: {
                        return ExprEval.of(dateTime.monthOfYear().get());
                    }
                    case QUARTER: {
                        return ExprEval.of((dateTime.monthOfYear().get() - 1) / 3 + 1);
                    }
                    case YEAR: {
                        return ExprEval.of(dateTime.year().get());
                    }
                }
                throw new ISE("Unhandled unit[%s]", new Object[]{unit});
            }

            @Override
            public void visit(Expr.Visitor visitor) {
                arg.visit(visitor);
                visitor.visit(this);
            }
        }
        return new TimestampExtractExpr();
    }

    public static enum Unit {
        EPOCH,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        DOW,
        DOY,
        WEEK,
        MONTH,
        QUARTER,
        YEAR;

    }
}

