/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.expression;

import com.google.inject.Inject;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprEval;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.query.lookup.LookupReferencesManager;
import org.apache.hive.druid.io.druid.query.lookup.RegisteredLookupExtractionFn;

public class LookupExprMacro
implements ExprMacroTable.ExprMacro {
    private final LookupReferencesManager lookupReferencesManager;

    @Inject
    public LookupExprMacro(LookupReferencesManager lookupReferencesManager) {
        this.lookupReferencesManager = lookupReferencesManager;
    }

    @Override
    public String name() {
        return "lookup";
    }

    @Override
    public Expr apply(List<Expr> args) {
        if (args.size() != 2) {
            throw new IAE("Function[%s] must have 2 arguments", this.name());
        }
        final Expr arg = args.get(0);
        Expr lookupExpr = args.get(1);
        if (!lookupExpr.isLiteral() || lookupExpr.getLiteralValue() == null) {
            throw new IAE("Function[%s] second argument must be a registered lookup name", this.name());
        }
        String lookupName = lookupExpr.getLiteralValue().toString();
        final RegisteredLookupExtractionFn extractionFn = new RegisteredLookupExtractionFn(this.lookupReferencesManager, lookupName, false, null, false, null);
        class LookupExpr
        implements Expr {
            LookupExpr() {
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                return ExprEval.of(extractionFn.apply(Strings.emptyToNull(arg.eval(bindings).asString())));
            }

            @Override
            public void visit(Expr.Visitor visitor) {
                arg.visit(visitor);
                visitor.visit(this);
            }
        }
        return new LookupExpr();
    }
}

