/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.first;

import org.apache.hive.druid.io.druid.collections.SerializablePair;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;

public class FloatFirstAggregator
implements Aggregator {
    private final FloatColumnSelector valueSelector;
    private final LongColumnSelector timeSelector;
    private final String name;
    protected long firstTime;
    protected float firstValue;

    public FloatFirstAggregator(String name, LongColumnSelector timeSelector, FloatColumnSelector valueSelector) {
        this.name = name;
        this.valueSelector = valueSelector;
        this.timeSelector = timeSelector;
        this.reset();
    }

    @Override
    public void aggregate() {
        long time = this.timeSelector.getLong();
        if (time < this.firstTime) {
            this.firstTime = time;
            this.firstValue = this.valueSelector.getFloat();
        }
    }

    @Override
    public void reset() {
        this.firstTime = Long.MAX_VALUE;
        this.firstValue = 0.0f;
    }

    @Override
    public Object get() {
        return new SerializablePair<Long, Float>(this.firstTime, Float.valueOf(this.firstValue));
    }

    @Override
    public float getFloat() {
        return this.firstValue;
    }

    @Override
    public double getDouble() {
        return this.firstValue;
    }

    @Override
    public long getLong() {
        return (long)this.firstValue;
    }

    @Override
    public void close() {
    }
}

