/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.cardinality.types;

import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Arrays;
import org.apache.hive.druid.com.google.common.hash.Hasher;
import org.apache.hive.druid.io.druid.hll.HyperLogLogCollector;
import org.apache.hive.druid.io.druid.query.aggregation.cardinality.CardinalityAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;

public class StringCardinalityAggregatorColumnSelectorStrategy
implements CardinalityAggregatorColumnSelectorStrategy<DimensionSelector> {
    public static final String CARDINALITY_AGG_NULL_STRING = "\u0000";
    public static final char CARDINALITY_AGG_SEPARATOR = '\u0001';

    @Override
    public void hashRow(DimensionSelector dimSelector, Hasher hasher) {
        IndexedInts row = dimSelector.getRow();
        int size = row.size();
        if (size == 1) {
            String value = dimSelector.lookupName(row.get(0));
            if (NullHandlingHelper.useDefaultValuesForNull() || value != null) {
                hasher.putUnencodedChars(this.nullToSpecial(value));
            }
        } else if (size != 0) {
            int i;
            boolean hasNonNullValue = false;
            Object[] values = new String[size];
            for (i = 0; i < size; ++i) {
                String value = dimSelector.lookupName(row.get(i));
                if (!NullHandlingHelper.useDefaultValuesForNull() && !hasNonNullValue && value != null) {
                    hasNonNullValue = true;
                }
                values[i] = this.nullToSpecial(value);
            }
            if (NullHandlingHelper.useDefaultValuesForNull() || hasNonNullValue) {
                Arrays.sort(values);
                for (i = 0; i < size; ++i) {
                    if (i != 0) {
                        hasher.putChar('\u0001');
                    }
                    hasher.putUnencodedChars((CharSequence)values[i]);
                }
            }
        }
    }

    @Override
    public void hashValues(DimensionSelector dimSelector, HyperLogLogCollector collector) {
        IntIterator rowIt = dimSelector.getRow().iterator();
        while (rowIt.hasNext()) {
            int index = rowIt.nextInt();
            String value = dimSelector.lookupName(index);
            if (!NullHandlingHelper.useDefaultValuesForNull() && value == null) continue;
            collector.add(CardinalityAggregator.hashFn.hashUnencodedChars(this.nullToSpecial(value)).asBytes());
        }
    }

    private String nullToSpecial(String value) {
        return value == null ? CARDINALITY_AGG_NULL_STRING : value;
    }
}

