/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorUtil;
import org.apache.hive.druid.io.druid.query.aggregation.FloatSumAggregator;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;

public abstract class SimpleFloatAggregatorFactory
extends AggregatorFactory {
    protected final String name;
    protected final String fieldName;
    protected final String expression;
    protected final ExprMacroTable macroTable;

    public SimpleFloatAggregatorFactory(ExprMacroTable macroTable, String name, String fieldName, String expression) {
        this.macroTable = macroTable;
        this.name = name;
        this.fieldName = fieldName;
        this.expression = expression;
        Preconditions.checkNotNull(name, "Must have a valid, non-null aggregator name");
        Preconditions.checkArgument(fieldName == null ^ expression == null, "Must have a valid, non-null fieldName or expression");
    }

    protected FloatColumnSelector getFloatColumnSelector(ColumnSelectorFactory metricFactory, Float nullValue) {
        return AggregatorUtil.getFloatColumnSelector(metricFactory, this.macroTable, this.fieldName, this.expression, nullValue.floatValue());
    }

    @Override
    public Object deserialize(Object object) {
        if (object instanceof String) {
            return Float.valueOf(Float.parseFloat((String)object));
        }
        return object;
    }

    @Override
    public String getTypeName() {
        return "float";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 4 + NullHandlingHelper.extraAggregatorBytes();
    }

    @Override
    public Comparator getComparator() {
        return FloatSumAggregator.COMPARATOR;
    }

    @Override
    public Object finalizeComputation(Object object) {
        return object;
    }

    @Override
    public List<String> requiredFields() {
        return this.fieldName != null ? Collections.singletonList(this.fieldName) : Parser.findRequiredBindings(Parser.parse(this.expression, this.macroTable));
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && this.getClass() == other.getClass()) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.expression, this.name);
    }
}

