/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;

public class NullableBufferAggregator
implements BufferAggregator {
    private static final byte IS_NULL_BYTE = 1;
    private static final byte IS_NOT_NULL_BYTE = 0;
    private final BufferAggregator delegate;
    private final ColumnValueSelector selector;

    public NullableBufferAggregator(BufferAggregator delegate, ColumnValueSelector selector) {
        this.delegate = delegate;
        this.selector = selector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.put(position, (byte)1);
        this.delegate.init(buf, position + 1);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        boolean isNotNull;
        boolean bl = isNotNull = !this.selector.isNull();
        if (isNotNull) {
            if (buf.get(position) == 1) {
                buf.put(position, (byte)0);
            }
            this.delegate.aggregate(buf, position + 1);
        }
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        if (buf.get(position) == 1) {
            return null;
        }
        return this.delegate.get(buf, position + 1);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return this.delegate.getFloat(buf, position + 1);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return this.delegate.getLong(buf, position + 1);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return this.delegate.getDouble(buf, position + 1);
    }

    @Override
    public boolean isNull(ByteBuffer buf, int position) {
        return buf.get(position) == 1;
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

