/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;

public class NullableAggregator
implements Aggregator {
    private final Aggregator delegate;
    private final ColumnValueSelector selector;
    private boolean isNullResult = true;

    public NullableAggregator(Aggregator delegate, ColumnValueSelector selector) {
        this.delegate = delegate;
        this.selector = selector;
    }

    @Override
    public void aggregate() {
        boolean isNotNull;
        boolean bl = isNotNull = !this.selector.isNull();
        if (isNotNull) {
            if (this.isNullResult) {
                this.isNullResult = false;
            }
            this.delegate.aggregate();
        }
    }

    @Override
    public void reset() {
        this.isNullResult = true;
        this.delegate.reset();
    }

    @Override
    @Nullable
    public Object get() {
        if (this.isNullResult) {
            return null;
        }
        return this.delegate.get();
    }

    @Override
    public float getFloat() {
        return this.delegate.getFloat();
    }

    @Override
    public long getLong() {
        return this.delegate.getLong();
    }

    @Override
    public double getDouble() {
        return this.delegate.getDouble();
    }

    @Override
    public boolean isNull() {
        return this.isNullResult;
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

