/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.util.Comparator;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregator;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;

public class LongMinAggregator
implements Aggregator {
    static final Comparator COMPARATOR = LongSumAggregator.COMPARATOR;
    private final LongColumnSelector selector;
    private long min;

    static long combineValues(Object lhs, Object rhs) {
        return Math.min(((Number)lhs).longValue(), ((Number)rhs).longValue());
    }

    public LongMinAggregator(LongColumnSelector selector) {
        this.selector = selector;
        this.reset();
    }

    @Override
    public void aggregate() {
        this.min = Math.min(this.min, this.selector.getLong());
    }

    @Override
    public void reset() {
        this.min = Long.MAX_VALUE;
    }

    @Override
    public Object get() {
        return this.min;
    }

    @Override
    public float getFloat() {
        return this.min;
    }

    @Override
    public long getLong() {
        return this.min;
    }

    @Override
    public double getDouble() {
        return this.min;
    }

    public Aggregator clone() {
        return new LongMinAggregator(this.selector);
    }

    @Override
    public void close() {
    }
}

