/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.util.Comparator;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregator;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;

public class LongMaxAggregator
implements Aggregator {
    static final Comparator COMPARATOR = LongSumAggregator.COMPARATOR;
    private final LongColumnSelector selector;
    private long max;

    static long combineValues(Object lhs, Object rhs) {
        return Math.max(((Number)lhs).longValue(), ((Number)rhs).longValue());
    }

    public LongMaxAggregator(LongColumnSelector selector) {
        this.selector = selector;
        this.reset();
    }

    @Override
    public void aggregate() {
        this.max = Math.max(this.max, this.selector.getLong());
    }

    @Override
    public void reset() {
        this.max = Long.MIN_VALUE;
    }

    @Override
    public Object get() {
        return this.max;
    }

    @Override
    public float getFloat() {
        return this.max;
    }

    @Override
    public long getLong() {
        return this.max;
    }

    @Override
    public double getDouble() {
        return this.max;
    }

    public Aggregator clone() {
        return new LongMaxAggregator(this.selector);
    }

    @Override
    public void close() {
    }
}

