/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.JavaScriptAggregator;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;

public class JavaScriptBufferAggregator
implements BufferAggregator {
    private final ObjectColumnSelector[] selectorList;
    private final JavaScriptAggregator.ScriptAggregator script;

    public JavaScriptBufferAggregator(List<ObjectColumnSelector> selectorList, JavaScriptAggregator.ScriptAggregator script) {
        this.selectorList = Lists.newArrayList(selectorList).toArray(new ObjectColumnSelector[0]);
        this.script = script;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putDouble(position, this.script.reset());
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        buf.putDouble(position, this.script.aggregate(buf.getDouble(position), this.selectorList));
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return buf.getDouble(position);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return (float)buf.getDouble(position);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return (long)buf.getDouble(position);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return buf.getDouble(position);
    }

    @Override
    public void close() {
        this.script.close();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selectorList", (T[])this.selectorList);
        inspector.visit("script", this.script);
    }
}

