/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.util.Arrays;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;

public class HistogramVisual {
    @JsonProperty
    public final double[] breaks;
    @JsonProperty
    public final double[] counts;
    @JsonProperty
    public final double[] quantiles;

    @JsonCreator
    public HistogramVisual(@JsonProperty double[] breaks, @JsonProperty double[] counts, @JsonProperty double[] quantiles) {
        Preconditions.checkArgument(breaks != null, "breaks must not be null");
        Preconditions.checkArgument(counts != null, "counts must not be null");
        Preconditions.checkArgument(breaks.length == counts.length + 1, "breaks.length must be counts.length + 1");
        this.breaks = breaks;
        this.counts = counts;
        this.quantiles = quantiles;
    }

    public HistogramVisual(float[] breaks, float[] counts, float[] quantiles) {
        int i;
        Preconditions.checkArgument(breaks != null, "breaks must not be null");
        Preconditions.checkArgument(counts != null, "counts must not be null");
        Preconditions.checkArgument(breaks.length == counts.length + 1, "breaks.length must be counts.length + 1");
        this.breaks = new double[breaks.length];
        this.counts = new double[counts.length];
        this.quantiles = new double[quantiles.length];
        for (i = 0; i < breaks.length; ++i) {
            this.breaks[i] = breaks[i];
        }
        for (i = 0; i < counts.length; ++i) {
            this.counts[i] = counts[i];
        }
        for (i = 0; i < quantiles.length; ++i) {
            this.quantiles[i] = quantiles[i];
        }
    }

    public String toString() {
        return "HistogramVisual{counts=" + Arrays.toString(this.counts) + ", breaks=" + Arrays.toString(this.breaks) + ", quantiles=" + Arrays.toString(this.quantiles) + '}';
    }
}

