/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.util.Comparator;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;

public class FloatSumAggregator
implements Aggregator {
    static final Comparator COMPARATOR = new Ordering(){

        @Override
        public int compare(Object o, Object o1) {
            return Float.compare(((Number)o).floatValue(), ((Number)o1).floatValue());
        }
    }.nullsFirst();
    private final FloatColumnSelector selector;
    private float sum;

    static double combineValues(Object lhs, Object rhs) {
        return ((Number)lhs).floatValue() + ((Number)rhs).floatValue();
    }

    public FloatSumAggregator(FloatColumnSelector selector) {
        this.selector = selector;
        this.sum = 0.0f;
    }

    @Override
    public void aggregate() {
        this.sum += this.selector.getFloat();
    }

    @Override
    public void reset() {
        this.sum = 0.0f;
    }

    @Override
    public Object get() {
        return Float.valueOf(this.sum);
    }

    @Override
    public float getFloat() {
        return this.sum;
    }

    @Override
    public long getLong() {
        return (long)this.sum;
    }

    @Override
    public double getDouble() {
        return this.sum;
    }

    public Aggregator clone() {
        return new FloatSumAggregator(this.selector);
    }

    @Override
    public void close() {
    }
}

