/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.nio.ByteBuffer;
import org.apache.hive.druid.io.druid.query.aggregation.SimpleFloatBufferAggregator;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;

public class FloatMinBufferAggregator
extends SimpleFloatBufferAggregator {
    FloatMinBufferAggregator(FloatColumnSelector selector) {
        super(selector);
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putFloat(position, Float.POSITIVE_INFINITY);
    }

    @Override
    public void putFirst(ByteBuffer buf, int position, float value) {
        if (!Float.isNaN(value)) {
            buf.putFloat(position, value);
        } else {
            this.init(buf, position);
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, float value) {
        buf.putFloat(position, Math.min(buf.getFloat(position), value));
    }
}

