/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMinAggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.FloatMinAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.FloatMinBufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.SimpleFloatAggregatorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;

public class FloatMinAggregatorFactory
extends SimpleFloatAggregatorFactory {
    @JsonCreator
    public FloatMinAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="expression") String expression, @JacksonInject ExprMacroTable macroTable) {
        super(macroTable, name, fieldName, expression);
    }

    public FloatMinAggregatorFactory(String name, String fieldName) {
        this(name, fieldName, null, ExprMacroTable.nil());
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        FloatColumnSelector floatColumnSelector = this.getFloatColumnSelector(metricFactory, Float.valueOf(Float.POSITIVE_INFINITY));
        return NullHandlingHelper.getNullableAggregator(new FloatMinAggregator(floatColumnSelector), (ColumnValueSelector)floatColumnSelector);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        FloatColumnSelector floatColumnSelector = this.getFloatColumnSelector(metricFactory, Float.valueOf(Float.POSITIVE_INFINITY));
        return NullHandlingHelper.getNullableAggregator(new FloatMinBufferAggregator(floatColumnSelector), (ColumnValueSelector)floatColumnSelector);
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return FloatMinAggregator.combineValues(lhs, rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return NullHandlingHelper.getNullableCombiner(new DoubleMinAggregateCombiner());
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new FloatMinAggregatorFactory(this.name, this.name, null, this.macroTable);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Arrays.asList(new FloatMinAggregatorFactory(this.fieldName, this.fieldName, this.expression, this.macroTable));
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8WithNullToEmpty(this.fieldName);
        byte[] expressionBytes = StringUtils.toUtf8WithNullToEmpty(this.expression);
        return ByteBuffer.allocate(2 + fieldNameBytes.length + expressionBytes.length).put((byte)14).put(fieldNameBytes).put((byte)-1).put(expressionBytes).array();
    }

    public String toString() {
        return "FloatMinAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", expression='" + this.expression + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatMinAggregatorFactory that = (FloatMinAggregatorFactory)o;
        if (!Objects.equals(this.fieldName, that.fieldName)) {
            return false;
        }
        if (!Objects.equals(this.expression, that.expression)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }
}

