/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMaxAggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMaxAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMaxBufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;

public class DoubleMaxAggregatorFactory
extends SimpleDoubleAggregatorFactory {
    @JsonCreator
    public DoubleMaxAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="expression") String expression, @JacksonInject ExprMacroTable macroTable) {
        super(macroTable, fieldName, name, expression);
    }

    public DoubleMaxAggregatorFactory(String name, String fieldName) {
        this(name, fieldName, null, ExprMacroTable.nil());
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        DoubleColumnSelector doubleColumnSelector = this.getDoubleColumnSelector(metricFactory, Double.NEGATIVE_INFINITY);
        return NullHandlingHelper.getNullableAggregator(new DoubleMaxAggregator(doubleColumnSelector), (ColumnValueSelector)doubleColumnSelector);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        DoubleColumnSelector doubleColumnSelector = this.getDoubleColumnSelector(metricFactory, Double.NEGATIVE_INFINITY);
        return NullHandlingHelper.getNullableAggregator(new DoubleMaxBufferAggregator(doubleColumnSelector), (ColumnValueSelector)doubleColumnSelector);
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return DoubleMaxAggregator.combineValues(lhs, rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return NullHandlingHelper.getNullableCombiner(new DoubleMaxAggregateCombiner());
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new DoubleMaxAggregatorFactory(this.name, this.name, null, this.macroTable);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new DoubleMaxAggregatorFactory(this.fieldName, this.fieldName, this.expression, this.macroTable));
    }

    @Override
    public Object finalizeComputation(Object object) {
        return object;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8WithNullToEmpty(this.fieldName);
        byte[] expressionBytes = StringUtils.toUtf8WithNullToEmpty(this.expression);
        return ByteBuffer.allocate(2 + fieldNameBytes.length + expressionBytes.length).put((byte)3).put(fieldNameBytes).put((byte)-1).put(expressionBytes).array();
    }

    public String toString() {
        return "DoubleMaxAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", expression='" + this.expression + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleMaxAggregatorFactory that = (DoubleMaxAggregatorFactory)o;
        if (!Objects.equals(this.fieldName, that.fieldName)) {
            return false;
        }
        if (!Objects.equals(this.expression, that.expression)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }
}

