/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.math.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hive.druid.io.druid.java.util.common.RE;
import org.apache.hive.druid.io.druid.math.expr.BinAndExpr;
import org.apache.hive.druid.io.druid.math.expr.BinDivExpr;
import org.apache.hive.druid.io.druid.math.expr.BinEqExpr;
import org.apache.hive.druid.io.druid.math.expr.BinGeqExpr;
import org.apache.hive.druid.io.druid.math.expr.BinGtExpr;
import org.apache.hive.druid.io.druid.math.expr.BinLeqExpr;
import org.apache.hive.druid.io.druid.math.expr.BinLtExpr;
import org.apache.hive.druid.io.druid.math.expr.BinMinusExpr;
import org.apache.hive.druid.io.druid.math.expr.BinModuloExpr;
import org.apache.hive.druid.io.druid.math.expr.BinMulExpr;
import org.apache.hive.druid.io.druid.math.expr.BinNeqExpr;
import org.apache.hive.druid.io.druid.math.expr.BinOrExpr;
import org.apache.hive.druid.io.druid.math.expr.BinPlusExpr;
import org.apache.hive.druid.io.druid.math.expr.BinPowExpr;
import org.apache.hive.druid.io.druid.math.expr.DoubleExpr;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.math.expr.Function;
import org.apache.hive.druid.io.druid.math.expr.FunctionExpr;
import org.apache.hive.druid.io.druid.math.expr.IdentifierExpr;
import org.apache.hive.druid.io.druid.math.expr.LongExpr;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.apache.hive.druid.io.druid.math.expr.StringExpr;
import org.apache.hive.druid.io.druid.math.expr.UnaryMinusExpr;
import org.apache.hive.druid.io.druid.math.expr.UnaryNotExpr;
import org.apache.hive.druid.io.druid.math.expr.antlr.ExprBaseListener;
import org.apache.hive.druid.io.druid.math.expr.antlr.ExprParser;

public class ExprListenerImpl
extends ExprBaseListener {
    private final Map<ParseTree, Object> nodes;
    private final ExprMacroTable macroTable;
    private final ParseTree rootNodeKey;

    ExprListenerImpl(ParseTree rootNodeKey, ExprMacroTable macroTable) {
        this.rootNodeKey = rootNodeKey;
        this.macroTable = macroTable;
        this.nodes = new HashMap<ParseTree, Object>();
    }

    Expr getAST() {
        return (Expr)this.nodes.get(this.rootNodeKey);
    }

    @Override
    public void exitUnaryOpExpr(ExprParser.UnaryOpExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(0)).getSymbol().getType();
        switch (opCode) {
            case 10: {
                this.nodes.put((ParseTree)ctx, new UnaryMinusExpr((Expr)this.nodes.get(ctx.getChild(1))));
                break;
            }
            case 11: {
                this.nodes.put((ParseTree)ctx, new UnaryNotExpr((Expr)this.nodes.get(ctx.getChild(1))));
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized unary operator " + ctx.getChild(0).getText());
            }
        }
    }

    @Override
    public void exitDoubleExpr(ExprParser.DoubleExprContext ctx) {
        this.nodes.put((ParseTree)ctx, new DoubleExpr(Double.parseDouble(ctx.getText())));
    }

    @Override
    public void exitAddSubExpr(ExprParser.AddSubExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        switch (opCode) {
            case 16: {
                this.nodes.put((ParseTree)ctx, new BinPlusExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 10: {
                this.nodes.put((ParseTree)ctx, new BinMinusExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized binary operator " + ctx.getChild(1).getText());
            }
        }
    }

    @Override
    public void exitLongExpr(ExprParser.LongExprContext ctx) {
        this.nodes.put((ParseTree)ctx, new LongExpr(Long.parseLong(ctx.getText())));
    }

    @Override
    public void exitLogicalAndOrExpr(ExprParser.LogicalAndOrExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        switch (opCode) {
            case 23: {
                this.nodes.put((ParseTree)ctx, new BinAndExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 24: {
                this.nodes.put((ParseTree)ctx, new BinOrExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized binary operator " + ctx.getChild(1).getText());
            }
        }
    }

    @Override
    public void exitNestedExpr(ExprParser.NestedExprContext ctx) {
        this.nodes.put((ParseTree)ctx, this.nodes.get(ctx.getChild(1)));
    }

    @Override
    public void exitString(ExprParser.StringContext ctx) {
        String text = ctx.getText();
        String unquoted = text.substring(1, text.length() - 1);
        String unescaped = unquoted.indexOf(92) >= 0 ? StringEscapeUtils.unescapeJava((String)unquoted) : unquoted;
        this.nodes.put((ParseTree)ctx, new StringExpr(unescaped));
    }

    @Override
    public void exitLogicalOpExpr(ExprParser.LogicalOpExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        switch (opCode) {
            case 17: {
                this.nodes.put((ParseTree)ctx, new BinLtExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 18: {
                this.nodes.put((ParseTree)ctx, new BinLeqExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 19: {
                this.nodes.put((ParseTree)ctx, new BinGtExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 20: {
                this.nodes.put((ParseTree)ctx, new BinGeqExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 21: {
                this.nodes.put((ParseTree)ctx, new BinEqExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 22: {
                this.nodes.put((ParseTree)ctx, new BinNeqExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized binary operator " + ctx.getChild(1).getText());
            }
        }
    }

    @Override
    public void exitMulDivModuloExpr(ExprParser.MulDivModuloExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        switch (opCode) {
            case 13: {
                this.nodes.put((ParseTree)ctx, new BinMulExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 14: {
                this.nodes.put((ParseTree)ctx, new BinDivExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 15: {
                this.nodes.put((ParseTree)ctx, new BinModuloExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized binary operator " + ctx.getChild(1).getText());
            }
        }
    }

    @Override
    public void exitPowOpExpr(ExprParser.PowOpExprContext ctx) {
        this.nodes.put((ParseTree)ctx, new BinPowExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
    }

    @Override
    public void exitFunctionExpr(ExprParser.FunctionExprContext ctx) {
        List args;
        String fnName = ctx.getChild(0).getText();
        Expr expr = this.macroTable.get(fnName, args = ctx.getChildCount() > 3 ? (List)this.nodes.get(ctx.getChild(2)) : Collections.emptyList());
        if (expr == null) {
            Function function = Parser.getFunction(fnName);
            if (function == null) {
                throw new RE("function '%s' is not defined.", fnName);
            }
            expr = new FunctionExpr(function, fnName, args);
        }
        this.nodes.put((ParseTree)ctx, expr);
    }

    @Override
    public void exitIdentifierExpr(ExprParser.IdentifierExprContext ctx) {
        String text = ctx.getText();
        if (text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"') {
            text = StringEscapeUtils.unescapeJava((String)text.substring(1, text.length() - 1));
        }
        this.nodes.put((ParseTree)ctx, new IdentifierExpr(text));
    }

    @Override
    public void exitFunctionArgs(ExprParser.FunctionArgsContext ctx) {
        ArrayList<Expr> args = new ArrayList<Expr>();
        args.add((Expr)this.nodes.get(ctx.getChild(0)));
        if (ctx.getChildCount() > 1) {
            for (int i = 1; i <= ctx.getChildCount() / 2; ++i) {
                args.add((Expr)this.nodes.get(ctx.getChild(2 * i)));
            }
        }
        this.nodes.put((ParseTree)ctx, args);
    }

    @Override
    public void exitNull(ExprParser.NullContext ctx) {
        this.nodes.put((ParseTree)ctx, new StringExpr(null));
    }
}

