/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.parsers;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ParseException;
import org.apache.hive.druid.io.druid.java.util.common.parsers.Parser;

public class ToLowerCaseParser
implements Parser<String, Object> {
    private final Parser baseParser;

    public ToLowerCaseParser(Parser baseParser) {
        this.baseParser = baseParser;
    }

    @Override
    public Map parse(String input) {
        Map line = this.baseParser.parse(input);
        LinkedHashMap retVal = Maps.newLinkedHashMap();
        for (Map.Entry entry : line.entrySet()) {
            String k = StringUtils.toLowerCase((String)entry.getKey());
            if (retVal.containsKey(k)) {
                throw new ParseException("Unparseable row. Duplicate key found : [%s]", k);
            }
            retVal.put(k, entry.getValue());
        }
        return retVal;
    }

    @Override
    public void startFileFromBeginning() {
        this.baseParser.startFileFromBeginning();
    }

    @Override
    public void setFieldNames(Iterable<String> fieldNames) {
        this.baseParser.setFieldNames(fieldNames);
    }

    @Override
    public List<String> getFieldNames() {
        return this.baseParser.getFieldNames();
    }
}

