/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.parsers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Splitter;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ParseException;
import org.apache.hive.druid.io.druid.java.util.common.parsers.TimestampParser;
import org.joda.time.DateTime;

public class ParserUtils {
    private static final String DEFAULT_COLUMN_NAME_PREFIX = "column_";

    public static Function<String, Object> getMultiValueFunction(String listDelimiter, Splitter listSplitter) {
        return input -> {
            if (input != null && input.contains(listDelimiter)) {
                return StreamSupport.stream(listSplitter.split((CharSequence)input).spliterator(), false).map(Strings::emptyToNull).collect(Collectors.toList());
            }
            return Strings.emptyToNull(input);
        };
    }

    public static ArrayList<String> generateFieldNames(int length) {
        ArrayList<String> names = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            names.add(ParserUtils.getDefaultColumnName(i));
        }
        return names;
    }

    public static Function<String, DateTime> createTimestampParser(String format) {
        return TimestampParser.createTimestampParser(format);
    }

    public static Set<String> findDuplicates(Iterable<String> fieldNames) {
        HashSet<String> duplicates = Sets.newHashSet();
        HashSet<String> uniqueNames = Sets.newHashSet();
        for (String fieldName : fieldNames) {
            String next = StringUtils.toLowerCase(fieldName);
            if (uniqueNames.contains(next)) {
                duplicates.add(next);
            }
            uniqueNames.add(next);
        }
        return duplicates;
    }

    public static void validateFields(Iterable<String> fieldNames) {
        Set<String> duplicates = ParserUtils.findDuplicates(fieldNames);
        if (!duplicates.isEmpty()) {
            throw new ParseException("Duplicate column entries found : %s", duplicates.toString());
        }
    }

    public static String stripQuotes(String input) {
        if ((input = input.trim()).charAt(0) == '\"' && input.charAt(input.length() - 1) == '\"') {
            input = input.substring(1, input.length() - 1).trim();
        }
        return input;
    }

    public static String getDefaultColumnName(int ordinal) {
        return DEFAULT_COLUMN_NAME_PREFIX + (ordinal + 1);
    }
}

