/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.parsers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Splitter;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.java.util.common.collect.Utils;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ParseException;
import org.apache.hive.druid.io.druid.java.util.common.parsers.Parser;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ParserUtils;

public abstract class AbstractFlatTextFormatParser
implements Parser<String, Object> {
    private final String listDelimiter;
    private final Splitter listSplitter;
    private final Function<String, Object> valueFunction;
    private final boolean hasHeaderRow;
    private final int maxSkipHeaderRows;
    private List<String> fieldNames = null;
    private boolean hasParsedHeader = false;
    private int skippedHeaderRows;
    private boolean supportSkipHeaderRows;

    public AbstractFlatTextFormatParser(@Nullable String listDelimiter, boolean hasHeaderRow, int maxSkipHeaderRows) {
        this.listDelimiter = listDelimiter != null ? listDelimiter : "\u0001";
        this.listSplitter = Splitter.on(this.listDelimiter);
        this.valueFunction = ParserUtils.getMultiValueFunction(this.listDelimiter, this.listSplitter);
        this.hasHeaderRow = hasHeaderRow;
        this.maxSkipHeaderRows = maxSkipHeaderRows;
    }

    @Override
    public void startFileFromBeginning() {
        if (this.hasHeaderRow) {
            this.fieldNames = null;
        }
        this.hasParsedHeader = false;
        this.skippedHeaderRows = 0;
        this.supportSkipHeaderRows = true;
    }

    public String getListDelimiter() {
        return this.listDelimiter;
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public void setFieldNames(Iterable<String> fieldNames) {
        if (fieldNames != null) {
            ArrayList<String> fieldsList = Lists.newArrayList(fieldNames);
            this.fieldNames = new ArrayList<String>(fieldsList.size());
            for (int i = 0; i < fieldsList.size(); ++i) {
                if (Strings.isNullOrEmpty((String)fieldsList.get(i))) {
                    this.fieldNames.add(ParserUtils.getDefaultColumnName(i));
                    continue;
                }
                this.fieldNames.add((String)fieldsList.get(i));
            }
            ParserUtils.validateFields(this.fieldNames);
        }
    }

    public void setFieldNames(String header) {
        try {
            this.setFieldNames(this.parseLine(header));
        }
        catch (Exception e) {
            throw new ParseException(e, "Unable to parse header [%s]", header);
        }
    }

    @Override
    public Map<String, Object> parse(String input) {
        if (!this.supportSkipHeaderRows && (this.hasHeaderRow || this.maxSkipHeaderRows > 0)) {
            throw new UnsupportedOperationException("hasHeaderRow or maxSkipHeaderRows is not supported. Please check the indexTask supports these options.");
        }
        try {
            List<String> values = this.parseLine(input);
            if (this.skippedHeaderRows < this.maxSkipHeaderRows) {
                ++this.skippedHeaderRows;
                return null;
            }
            if (this.hasHeaderRow && !this.hasParsedHeader) {
                if (this.fieldNames == null) {
                    this.setFieldNames(values);
                }
                this.hasParsedHeader = true;
                return null;
            }
            if (this.fieldNames == null) {
                this.setFieldNames(ParserUtils.generateFieldNames(values.size()));
            }
            return Utils.zipMapPartial(this.fieldNames, Iterables.transform(values, this.valueFunction));
        }
        catch (Exception e) {
            throw new ParseException(e, "Unable to parse row [%s]", input);
        }
    }

    protected abstract List<String> parseLine(String var1) throws IOException;

    public static enum FlatTextFormat {
        CSV(","),
        DELIMITED("\t");

        private final String defaultDelimiter;

        private FlatTextFormat(String defaultDelimiter) {
            this.defaultDelimiter = defaultDelimiter;
        }

        public String getDefaultDelimiter() {
            return this.defaultDelimiter;
        }
    }
}

