/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.logger;

import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.slf4j.LoggerFactory;

public class Logger {
    private final org.slf4j.Logger log;

    public Logger(String name) {
        this.log = LoggerFactory.getLogger((String)name);
    }

    public Logger(Class clazz) {
        this.log = LoggerFactory.getLogger((Class)clazz);
    }

    public void trace(String message, Object ... formatArgs) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(StringUtils.nonStrictFormat(message, formatArgs));
        }
    }

    public void trace(Throwable t, String message, Object ... formatArgs) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(StringUtils.nonStrictFormat(message, formatArgs), t);
        }
    }

    public void debug(String message, Object ... formatArgs) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(StringUtils.nonStrictFormat(message, formatArgs));
        }
    }

    public void debug(Throwable t, String message, Object ... formatArgs) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(StringUtils.nonStrictFormat(message, formatArgs), t);
        }
    }

    public void info(String message, Object ... formatArgs) {
        if (this.log.isInfoEnabled()) {
            this.log.info(StringUtils.nonStrictFormat(message, formatArgs));
        }
    }

    public void info(Throwable t, String message, Object ... formatArgs) {
        if (this.log.isInfoEnabled()) {
            this.log.info(StringUtils.nonStrictFormat(message, formatArgs), t);
        }
    }

    @Deprecated
    public void warn(String message, Throwable t) {
        this.log.warn(message, t);
    }

    public void warn(String message, Object ... formatArgs) {
        this.log.warn(StringUtils.nonStrictFormat(message, formatArgs));
    }

    public void warn(Throwable t, String message, Object ... formatArgs) {
        this.log.warn(StringUtils.nonStrictFormat(message, formatArgs), t);
    }

    public void error(String message, Object ... formatArgs) {
        this.log.error(StringUtils.nonStrictFormat(message, formatArgs));
    }

    @Deprecated
    public void error(String message, Throwable t) {
        this.log.error(message, t);
    }

    public void error(Throwable t, String message, Object ... formatArgs) {
        this.log.error(StringUtils.nonStrictFormat(message, formatArgs), t);
    }

    public void wtf(String message, Object ... formatArgs) {
        this.log.error(StringUtils.nonStrictFormat("WTF?!: " + message, formatArgs), (Throwable)new Exception());
    }

    public void wtf(Throwable t, String message, Object ... formatArgs) {
        this.log.error(StringUtils.nonStrictFormat("WTF?!: " + message, formatArgs), t);
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }
}

