/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.guice.http;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import javax.net.ssl.SSLContext;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.com.metamx.http.client.HttpClientConfig;
import org.apache.hive.druid.com.metamx.http.client.HttpClientInit;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.guice.annotations.Global;
import org.apache.hive.druid.io.druid.guice.http.AbstractHttpClientProvider;
import org.apache.hive.druid.io.druid.guice.http.DruidHttpClientConfig;
import org.apache.hive.druid.io.druid.guice.http.LifecycleUtils;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.Lifecycle;

public class HttpClientModule
implements Module {
    private final String propertyPrefix;
    private Annotation annotation = null;
    private Class<? extends Annotation> annotationClazz = null;

    public static HttpClientModule global() {
        return new HttpClientModule("druid.global.http", Global.class);
    }

    public HttpClientModule(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
    }

    public HttpClientModule(String propertyPrefix, Class<? extends Annotation> annotation) {
        this.propertyPrefix = propertyPrefix;
        this.annotationClazz = annotation;
    }

    public HttpClientModule(String propertyPrefix, Annotation annotation) {
        this.propertyPrefix = propertyPrefix;
        this.annotation = annotation;
    }

    public void configure(Binder binder) {
        if (this.annotation != null) {
            JsonConfigProvider.bind(binder, this.propertyPrefix, DruidHttpClientConfig.class, this.annotation);
            binder.bind(HttpClient.class).annotatedWith(this.annotation).toProvider((Provider)new HttpClientProvider(this.annotation)).in(LazySingleton.class);
        } else if (this.annotationClazz != null) {
            JsonConfigProvider.bind(binder, this.propertyPrefix, DruidHttpClientConfig.class, this.annotationClazz);
            binder.bind(HttpClient.class).annotatedWith(this.annotationClazz).toProvider((Provider)new HttpClientProvider(this.annotationClazz)).in(LazySingleton.class);
        } else {
            JsonConfigProvider.bind(binder, this.propertyPrefix, DruidHttpClientConfig.class);
            binder.bind(HttpClient.class).toProvider((Provider)new HttpClientProvider()).in(LazySingleton.class);
        }
    }

    public static class HttpClientProvider
    extends AbstractHttpClientProvider<HttpClient> {
        public HttpClientProvider() {
        }

        public HttpClientProvider(Annotation annotation) {
            super(annotation);
        }

        public HttpClientProvider(Class<? extends Annotation> annotationClazz) {
            super(annotationClazz);
        }

        public HttpClient get() {
            DruidHttpClientConfig config = (DruidHttpClientConfig)((Supplier)this.getConfigProvider().get()).get();
            HttpClientConfig.Builder builder = HttpClientConfig.builder().withNumConnections(config.getNumConnections()).withReadTimeout(config.getReadTimeout()).withWorkerCount(config.getNumMaxThreads()).withCompressionCodec(HttpClientConfig.CompressionCodec.valueOf(StringUtils.toUpperCase(config.getCompressionCodec())));
            if (this.getSslContextBinding() != null) {
                builder.withSslContext((SSLContext)this.getSslContextBinding().getProvider().get());
            }
            return HttpClientInit.createClient(builder.build(), LifecycleUtils.asMmxLifecycle((Lifecycle)this.getLifecycleProvider().get()));
        }
    }
}

