/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Provides;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.databind.Module;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.guice.annotations.Self;
import org.apache.hive.druid.io.druid.initialization.DruidModule;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.io.druid.server.DruidNode;
import org.apache.hive.druid.io.druid.server.initialization.ZkPathsConfig;
import org.apache.hive.druid.io.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.LinearShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.SingleDimensionShardSpec;

public class ServerModule
implements DruidModule {
    public static final String ZK_PATHS_PROPERTY_BASE = "druid.zk.paths";

    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, ZK_PATHS_PROPERTY_BASE, ZkPathsConfig.class);
        JsonConfigProvider.bind(binder, "druid", DruidNode.class, Self.class);
    }

    @Provides
    @LazySingleton
    public ScheduledExecutorFactory getScheduledExecutorFactory(Lifecycle lifecycle) {
        return ScheduledExecutors.createFactory(lifecycle);
    }

    @Override
    public List<? extends Module> getJacksonModules() {
        return Collections.singletonList(new SimpleModule().registerSubtypes(new NamedType(SingleDimensionShardSpec.class, "single"), new NamedType(LinearShardSpec.class, "linear"), new NamedType(NumberedShardSpec.class, "numbered"), new NamedType(HashBasedNumberedShardSpec.class, "hashed")));
    }
}

