/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.guice.ConfigModule;
import org.apache.hive.druid.io.druid.guice.DruidGuiceExtensions;
import org.apache.hive.druid.io.druid.guice.DruidSecondaryModule;
import org.apache.hive.druid.io.druid.guice.ExtensionsConfig;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.ModulesConfig;
import org.apache.hive.druid.io.druid.guice.NullHandlingModule;
import org.apache.hive.druid.io.druid.guice.PropertiesModule;
import org.apache.hive.druid.io.druid.jackson.JacksonModule;

public class GuiceInjectors {
    public static Collection<Module> makeDefaultStartupModules() {
        return ImmutableList.of(new DruidGuiceExtensions(), new JacksonModule(), new PropertiesModule(Arrays.asList("common.runtime.properties", "runtime.properties")), new ConfigModule(), new NullHandlingModule(), new Module(){

            public void configure(Binder binder) {
                binder.bind(DruidSecondaryModule.class);
                JsonConfigProvider.bind(binder, "druid.extensions", ExtensionsConfig.class);
                JsonConfigProvider.bind(binder, "druid.modules", ModulesConfig.class);
            }
        });
    }

    public static Injector makeStartupInjector() {
        return Guice.createInjector(GuiceInjectors.makeDefaultStartupModules());
    }

    public static Injector makeStartupInjectorWithModules(Iterable<? extends Module> modules) {
        ArrayList<Module> theModules = Lists.newArrayList();
        theModules.addAll(GuiceInjectors.makeDefaultStartupModules());
        for (Module module : modules) {
            theModules.add(module);
        }
        return Guice.createInjector(theModules);
    }
}

